/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.performance.MeasuredPerformance;
import com.rapidminer.tools.math.Averagable;
import com.rapidminer.tools.math.ROCBias;
import com.rapidminer.tools.math.ROCData;
import com.rapidminer.tools.math.ROCDataGenerator;
import java.util.LinkedList;
import java.util.List;

public class AreaUnderCurve
extends MeasuredPerformance {
    private static final long serialVersionUID = 6877715214974493828L;
    private double auc = Double.NaN;
    private transient ROCDataGenerator rocDataGenerator = new ROCDataGenerator(1.0, 1.0);
    private LinkedList<ROCData> rocData = new LinkedList();
    private int counter = 1;
    private String positiveClass;
    private ROCBias method;

    public AreaUnderCurve() {
        this.method = ROCBias.OPTIMISTIC;
    }

    public AreaUnderCurve(ROCBias method) {
        this.method = method;
    }

    public AreaUnderCurve(AreaUnderCurve aucObject) {
        super(aucObject);
        this.auc = aucObject.auc;
        this.counter = aucObject.counter;
        this.positiveClass = aucObject.positiveClass;
        this.method = aucObject.method;
    }

    @Override
    public void startCounting(ExampleSet exampleSet, boolean useExampleWeights) throws OperatorException {
        super.startCounting(exampleSet, useExampleWeights);
        this.rocData.add(this.rocDataGenerator.createROCData(exampleSet, useExampleWeights, this.method));
        this.auc = this.rocDataGenerator.calculateAUC(this.rocData.getLast());
        this.positiveClass = exampleSet.getAttributes().getPredictedLabel().getMapping().getPositiveString();
    }

    @Override
    public void countExample(Example example) {
    }

    @Override
    public double getExampleCount() {
        return 1.0;
    }

    @Override
    public double getMikroVariance() {
        return Double.NaN;
    }

    @Override
    public double getMikroAverage() {
        return this.auc / (double)this.counter;
    }

    @Override
    public double getFitness() {
        return this.getAverage();
    }

    @Override
    public String getName() {
        if (this.method == ROCBias.NEUTRAL) {
            return "AUC";
        }
        return "AUC (" + this.method.toString().toLowerCase() + ")";
    }

    @Override
    public String getDescription() {
        return "The area under a ROC curve. Given example weights are also considered. Please note that the second class is considered to be positive.";
    }

    @Override
    public void buildSingleAverage(Averagable performance) {
        AreaUnderCurve other = (AreaUnderCurve)performance;
        this.counter += other.counter;
        this.auc += other.auc;
        this.rocData.addAll(other.rocData);
    }

    @Override
    public String toString() {
        return super.toString() + " (positive class: " + this.positiveClass + ")";
    }

    public List<ROCData> getRocData() {
        return this.rocData;
    }

    public ROCDataGenerator getRocDataGenerator() {
        return this.rocDataGenerator;
    }

    public static class Neutral
    extends AreaUnderCurve {
        private static final long serialVersionUID = 1L;

        public Neutral() {
            super(ROCBias.NEUTRAL);
        }
    }

    public static class Pessimistic
    extends AreaUnderCurve {
        private static final long serialVersionUID = 1L;

        public Pessimistic() {
            super(ROCBias.PESSIMISTIC);
        }
    }

    public static class Optimistic
    extends AreaUnderCurve {
        private static final long serialVersionUID = 1L;

        public Optimistic() {
            super(ROCBias.OPTIMISTIC);
        }
    }
}

