/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.PassThroughRule;

public abstract class AbstractExampleSetEvaluator
extends Operator {
    private InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private OutputPort performanceOutput = (OutputPort)this.getOutputPorts().createPort("performance");
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");

    public AbstractExampleSetEvaluator(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule(new PassThroughRule(this.exampleSetInput, this.exampleSetOutput, false));
        this.getTransformer().addRule(new GenerateNewMDRule(this.performanceOutput, PerformanceVector.class));
    }

    public abstract PerformanceVector evaluate(ExampleSet var1) throws OperatorException;

    @Override
    public void doWork() throws OperatorException {
        ExampleSet input = (ExampleSet)this.exampleSetInput.getData();
        this.performanceOutput.deliver(this.evaluate(input));
        this.exampleSetOutput.deliver(input);
    }

    @Override
    public boolean shouldAutoConnect(OutputPort port) {
        if (port == this.exampleSetOutput) {
            return this.getParameterAsBoolean("keep_example_set");
        }
        return super.shouldAutoConnect(port);
    }
}

