/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.nio.model;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.nio.ImportWizardUtils;
import com.rapidminer.operator.nio.model.AbstractDataResultSetReader;
import com.rapidminer.operator.nio.model.DataResultSet;
import com.rapidminer.operator.nio.model.DataResultSetFactory;
import com.rapidminer.operator.nio.model.DataResultSetTranslationConfiguration;
import com.rapidminer.operator.nio.model.DataResultSetTranslator;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ProgressListener;

public class WizardState {
    private final DataResultSetTranslator translator;
    private final DataResultSetTranslationConfiguration config;
    private final DataResultSetFactory dataResultSetFactory;
    private final AbstractDataResultSetReader operator;
    private final int maxRows = ImportWizardUtils.getPreviewLength();

    public WizardState(AbstractDataResultSetReader operator, DataResultSetFactory dataResultSetFactory) {
        this.config = new DataResultSetTranslationConfiguration(operator);
        this.translator = new DataResultSetTranslator(operator);
        this.operator = operator;
        this.dataResultSetFactory = dataResultSetFactory;
    }

    public DataResultSetTranslator getTranslator() {
        return this.translator;
    }

    public DataResultSetTranslationConfiguration getTranslationConfiguration() {
        return this.config;
    }

    public DataResultSetFactory getDataResultSetFactory() {
        return this.dataResultSetFactory;
    }

    public ExampleSet readNow(DataResultSet dataResultSet, boolean previewOnly, ProgressListener progressListener) throws OperatorException {
        LogService.getRoot().info("Reading example set...");
        ExampleSet cachedExampleSet = this.getTranslator().read(dataResultSet, this.getTranslationConfiguration(), previewOnly, progressListener);
        return cachedExampleSet;
    }

    public int getNumberOfPreviewRows() {
        return this.maxRows;
    }

    public AbstractDataResultSetReader getOperator() {
        return this.operator;
    }
}

