/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.nio.model;

public class ParsingError {
    private final int row;
    private int exampleIndex;
    private final int column;
    private final Object originalValue;
    private final ErrorCode errorCode;
    private final Throwable cause;

    public ParsingError(int row, int column, ErrorCode errorCode, Object originalValue) {
        this(row, column, errorCode, originalValue, null);
    }

    public ParsingError(int row, int column, ErrorCode errorCode, Object originalValue, Throwable cause) {
        this.row = row;
        this.column = column;
        this.originalValue = originalValue;
        this.errorCode = errorCode;
        this.setExampleIndex(row);
        this.cause = cause;
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public Object getOriginalValue() {
        return this.originalValue;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public void setExampleIndex(int exampleIndex) {
        this.exampleIndex = exampleIndex;
    }

    public int getExampleIndex() {
        return this.exampleIndex;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public String toString() {
        return "line " + this.getRow() + ", column " + this.getColumn() + ": " + this.getErrorCode().getMessage() + "(" + this.getOriginalValue() + ")";
    }

    public static enum ErrorCode {
        UNPARSEABLE_DATE("unparseable date"),
        UNPARSEABLE_INTEGER("unparseable integer"),
        UNPARSEABLE_REAL("unparseable real number"),
        MORE_THAN_TWO_VALUES("more than two values for binominal attribute"),
        ROW_TOO_LONG("row too long"),
        FILE_SYNTAX_ERROR("file syntax error");

        private final String message;

        private ErrorCode(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

