/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.nio.model;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.nio.ExcelExampleSource;
import com.rapidminer.operator.nio.ExcelSheetTableModel;
import com.rapidminer.operator.nio.model.AbstractDataResultSetReader;
import com.rapidminer.operator.nio.model.DataResultSet;
import com.rapidminer.operator.nio.model.DataResultSetFactory;
import com.rapidminer.operator.nio.model.ExcelResultSet;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.Tools;
import java.io.File;
import java.io.IOException;
import javax.swing.table.TableModel;
import jxl.Workbook;
import jxl.read.biff.BiffException;

public class ExcelResultSetConfiguration
implements DataResultSetFactory {
    private int rowOffset = -1;
    private int columnOffset = -1;
    private int rowLast = Integer.MAX_VALUE;
    private int columnLast = Integer.MAX_VALUE;
    private int sheet = -1;
    private Workbook preOpenedWorkbook;
    private File workbookFile;
    private boolean isEmulatingOldNames;

    public ExcelResultSetConfiguration(ExcelExampleSource excelExampleSource) throws OperatorException {
        if (excelExampleSource.isParameterSet("imported_cell_range")) {
            this.parseExcelRange(excelExampleSource.getParameterAsString("imported_cell_range"));
        }
        if (excelExampleSource.isParameterSet("sheet_number")) {
            this.sheet = excelExampleSource.getParameterAsInt("sheet_number") - 1;
        }
        if (excelExampleSource.isParameterSet("excel_file")) {
            this.workbookFile = excelExampleSource.getParameterAsFile("excel_file");
        }
        this.isEmulatingOldNames = excelExampleSource.getCompatibilityLevel().isAtMost(ExcelExampleSource.CHANGE_5_0_11_NAME_SCHEMA);
    }

    public ExcelResultSetConfiguration() {
    }

    public int getRowOffset() {
        return this.rowOffset;
    }

    public int getColumnOffset() {
        return this.columnOffset;
    }

    public boolean hasWorkbook() {
        return this.preOpenedWorkbook != null;
    }

    public Workbook getWorkbook() throws BiffException, IOException {
        if (this.preOpenedWorkbook == null) {
            File file = this.getFile();
            this.preOpenedWorkbook = Workbook.getWorkbook((File)file);
        }
        return this.preOpenedWorkbook;
    }

    public File getFile() {
        return this.workbookFile;
    }

    public void setWorkbookFile(File selectedFile) {
        if (selectedFile.equals(this.workbookFile)) {
            return;
        }
        if (this.hasWorkbook()) {
            this.preOpenedWorkbook.close();
            this.preOpenedWorkbook = null;
        }
        this.workbookFile = selectedFile;
        this.preOpenedWorkbook = null;
        this.rowOffset = 0;
        this.columnOffset = 0;
        this.rowLast = Integer.MAX_VALUE;
        this.columnLast = Integer.MAX_VALUE;
        this.sheet = 0;
    }

    public int getRowLast() {
        return this.rowLast;
    }

    public void setRowLast(int rowLast) {
        this.rowLast = rowLast;
    }

    public int getColumnLast() {
        return this.columnLast;
    }

    public void setColumnLast(int columnLast) {
        this.columnLast = columnLast;
    }

    public int getSheet() {
        return this.sheet;
    }

    public void setSheet(int sheet) {
        this.sheet = sheet;
    }

    public void setRowOffset(int rowOffset) {
        this.rowOffset = rowOffset;
    }

    public void setColumnOffset(int columnOffset) {
        this.columnOffset = columnOffset;
    }

    @Override
    public DataResultSet makeDataResultSet(Operator operator) throws OperatorException {
        return new ExcelResultSet(operator, this);
    }

    @Override
    public TableModel makePreviewTableModel(ProgressListener listener) throws OperatorException {
        try {
            return new ExcelSheetTableModel(this);
        }
        catch (IndexOutOfBoundsException e) {
            throw new UserError(null, 302, this.getFile().getPath(), e.getMessage());
        }
        catch (BiffException e) {
            throw new UserError(null, 302, this.getFile().getPath(), e.getMessage());
        }
        catch (IOException e) {
            throw new UserError(null, 302, this.getFile().getPath(), e.getMessage());
        }
    }

    public void closeWorkbook() {
        if (this.preOpenedWorkbook != null) {
            this.preOpenedWorkbook.close();
            this.preOpenedWorkbook = null;
        }
    }

    @Override
    public void setParameters(AbstractDataResultSetReader source) {
        String range = Tools.getExcelColumnName(this.columnOffset) + (this.rowOffset + 1) + ":" + Tools.getExcelColumnName(this.columnLast) + (this.rowLast + 1);
        source.setParameter("imported_cell_range", range);
        source.setParameter("sheet_number", String.valueOf(this.sheet + 1));
        source.setParameter("excel_file", this.workbookFile.getAbsolutePath());
    }

    public void parseExcelRange(String range) throws OperatorException {
        String[] split = range.split(":", 2);
        try {
            int[] topLeft = ExcelResultSetConfiguration.parseExcelCell(split[0]);
            this.columnOffset = topLeft[0];
            this.rowOffset = topLeft[1];
            if (split.length < 2) {
                this.rowLast = Integer.MAX_VALUE;
                this.columnLast = Integer.MAX_VALUE;
            } else {
                int[] bottomRight = ExcelResultSetConfiguration.parseExcelCell(split[1]);
                this.columnLast = bottomRight[0];
                this.rowLast = bottomRight[1];
            }
        }
        catch (OperatorException e) {
            throw new UserError(null, (Throwable)e, 223, new Object[]{range});
        }
    }

    private static int[] parseExcelCell(String string) throws OperatorException {
        int i;
        int column = 0;
        int row = 0;
        for (i = 0; i < string.length() && Character.isLetter(string.charAt(i)); ++i) {
            char c = string.charAt(i);
            if ((c = Character.toUpperCase(c)) < 'A' || c > 'Z') {
                throw new UserError(null, 224, string);
            }
            column *= 26;
            column += c - 65 + 1;
        }
        if (i < string.length()) {
            String columnStr = string.substring(i);
            try {
                row = Integer.parseInt(columnStr);
            }
            catch (NumberFormatException e) {
                throw new UserError(null, 224, string);
            }
        }
        return new int[]{column - 1, row - 1};
    }

    @Override
    public String getResourceName() {
        return this.workbookFile.getAbsolutePath();
    }

    @Override
    public ExampleSetMetaData makeMetaData() {
        ExampleSetMetaData result = new ExampleSetMetaData();
        if (this.rowLast != Integer.MAX_VALUE) {
            result.setNumberOfExamples(this.rowLast - this.rowOffset + 1);
        }
        return result;
    }

    public boolean isEmulatingOldNames() {
        return this.isEmulatingOldNames;
    }

    @Override
    public void close() {
        if (this.preOpenedWorkbook != null) {
            this.preOpenedWorkbook.close();
        }
    }
}

