/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.nio.model;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.nio.model.DataResultSet;
import com.rapidminer.operator.nio.model.ExcelResultSetConfiguration;
import com.rapidminer.operator.nio.model.ParseException;
import com.rapidminer.operator.nio.model.ParsingError;
import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.Tools;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.NoSuchElementException;
import jxl.Cell;
import jxl.CellType;
import jxl.DateCell;
import jxl.NumberCell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;

public class ExcelResultSet
implements DataResultSet {
    private Sheet sheet = null;
    private boolean[] emptyRows;
    private boolean[] emptyColumns;
    private int rowOffset = 0;
    private int columnOffset = 0;
    private int totalNumberOfRows = 0;
    private int totalNumberOfColumns = 0;
    private int currentRow;
    private Cell[] currentRowCells;
    private Workbook workbook;
    private String[] attributeNames;

    public ExcelResultSet(Operator callingOperator, ExcelResultSetConfiguration configuration) throws OperatorException {
        int i;
        this.columnOffset = configuration.getColumnOffset();
        this.rowOffset = configuration.getRowOffset();
        this.currentRow = configuration.getRowOffset() - 1;
        if (this.columnOffset > configuration.getColumnLast() || this.rowOffset > configuration.getRowLast()) {
            throw new UserError(callingOperator, 223, Tools.getExcelColumnName(this.columnOffset) + this.rowOffset + ":" + Tools.getExcelColumnName(configuration.getColumnLast()) + configuration.getRowLast());
        }
        try {
            this.workbook = configuration.getWorkbook();
        }
        catch (IOException e) {
            throw new UserError(callingOperator, 302, configuration.getFile().getPath(), e.getMessage());
        }
        catch (BiffException e) {
            throw new UserError(callingOperator, 302, configuration.getFile().getPath(), e.getMessage());
        }
        try {
            this.sheet = this.workbook.getSheet(configuration.getSheet());
        }
        catch (IndexOutOfBoundsException e) {
            throw new UserError(callingOperator, 953, configuration.getSheet());
        }
        this.totalNumberOfColumns = Math.min(configuration.getColumnLast(), this.sheet.getColumns() - 1) - this.columnOffset + 1;
        this.totalNumberOfRows = Math.min(configuration.getRowLast(), this.sheet.getRows() - 1) - this.rowOffset + 1;
        if (this.totalNumberOfColumns < 0 || this.totalNumberOfRows < 0) {
            throw new UserError(callingOperator, 404);
        }
        this.emptyColumns = new boolean[this.totalNumberOfColumns];
        this.emptyRows = new boolean[this.totalNumberOfRows];
        Arrays.fill(this.emptyColumns, true);
        Arrays.fill(this.emptyRows, true);
        boolean foundAny = false;
        for (int r = 0; r < this.totalNumberOfRows; ++r) {
            for (int c = 0; c < this.totalNumberOfColumns; ++c) {
                Cell cell;
                if (!this.emptyRows[r] && !this.emptyColumns[c] || (cell = this.sheet.getCell(c + this.columnOffset, r + this.rowOffset)).getType() == CellType.EMPTY || "".equals(cell.getContents().trim())) continue;
                foundAny = true;
                this.emptyRows[r] = false;
                this.emptyColumns[c] = false;
            }
        }
        if (!foundAny) {
            throw new UserError(callingOperator, 302, configuration.getFile().getPath(), "spreadsheet seems to be empty");
        }
        int numberOfAttributes = 0;
        for (i = 0; i < this.totalNumberOfColumns; ++i) {
            if (this.emptyColumns[i]) continue;
            ++numberOfAttributes;
        }
        this.attributeNames = new String[numberOfAttributes];
        if (!configuration.isEmulatingOldNames()) {
            for (i = 0; i < numberOfAttributes; ++i) {
                if (this.emptyColumns[i]) continue;
                this.attributeNames[i] = Tools.getExcelColumnName(i);
            }
        } else {
            for (i = 0; i < numberOfAttributes; ++i) {
                if (this.emptyColumns[i]) continue;
                this.attributeNames[i] = "attribute_" + i;
            }
        }
    }

    @Override
    public void reset(ProgressListener listener) {
        this.currentRow = this.rowOffset - 1;
        if (listener != null) {
            listener.setTotal(this.totalNumberOfRows);
            listener.setCompleted(0);
        }
    }

    @Override
    public boolean hasNext() {
        int nextRow;
        for (nextRow = this.currentRow + 1; nextRow < this.totalNumberOfRows + this.rowOffset && this.emptyRows[nextRow - this.rowOffset]; ++nextRow) {
        }
        return nextRow < this.totalNumberOfRows + this.rowOffset;
    }

    @Override
    public void next(ProgressListener listener) {
        ++this.currentRow;
        while (this.currentRow < this.totalNumberOfRows + this.rowOffset && this.emptyRows[this.currentRow - this.rowOffset]) {
            ++this.currentRow;
        }
        if (this.currentRow >= this.totalNumberOfRows + this.rowOffset) {
            throw new NoSuchElementException("No further row in excel sheet.");
        }
        this.currentRowCells = new Cell[this.attributeNames.length];
        int columnCounter = 0;
        for (int c = 0; c < this.totalNumberOfColumns; ++c) {
            if (this.emptyColumns[c]) continue;
            this.currentRowCells[columnCounter] = this.sheet.getCell(c + this.columnOffset, this.currentRow);
            ++columnCounter;
        }
        if (listener != null) {
            listener.setCompleted(this.currentRow);
        }
    }

    @Override
    public void close() throws OperatorException {
    }

    @Override
    public int getNumberOfColumns() {
        return this.attributeNames.length;
    }

    @Override
    public String[] getColumnNames() {
        return this.attributeNames;
    }

    @Override
    public boolean isMissing(int columnIndex) {
        Cell cell = this.getCurrentCell(columnIndex);
        return cell.getType() == CellType.EMPTY || cell.getType() == CellType.ERROR || cell.getType() == CellType.FORMULA_ERROR || cell.getContents() == null || "".equals(cell.getContents().trim());
    }

    private Cell getCurrentCell(int index) {
        return this.currentRowCells[index];
    }

    @Override
    public Number getNumber(int columnIndex) throws ParseException {
        Cell cell = this.getCurrentCell(columnIndex);
        if (cell.getType() == CellType.NUMBER || cell.getType() == CellType.NUMBER_FORMULA) {
            double value = ((NumberCell)cell).getValue();
            return value;
        }
        String valueString = cell.getContents();
        try {
            return Double.valueOf(valueString);
        }
        catch (NumberFormatException e) {
            throw new ParseException(new ParsingError(this.currentRow, columnIndex, ParsingError.ErrorCode.UNPARSEABLE_REAL, valueString));
        }
    }

    @Override
    public Date getDate(int columnIndex) throws ParseException {
        Cell cell = this.getCurrentCell(columnIndex);
        if (cell.getType() == CellType.DATE || cell.getType() == CellType.DATE_FORMULA) {
            return ((DateCell)cell).getDate();
        }
        String valueString = cell.getContents();
        throw new ParseException(new ParsingError(this.currentRow, columnIndex, ParsingError.ErrorCode.UNPARSEABLE_DATE, valueString));
    }

    @Override
    public String getString(int columnIndex) {
        return this.getCurrentCell(columnIndex).getContents();
    }

    @Override
    public int[] getValueTypes() {
        return new int[this.attributeNames.length];
    }

    @Override
    public DataResultSet.ValueType getNativeValueType(int columnIndex) throws ParseException {
        CellType type = this.getCurrentCell(columnIndex).getType();
        if (type == CellType.EMPTY) {
            return DataResultSet.ValueType.EMPTY;
        }
        if (type == CellType.NUMBER || type == CellType.NUMBER_FORMULA) {
            return DataResultSet.ValueType.NUMBER;
        }
        if (type == CellType.DATE || type == CellType.DATE_FORMULA) {
            return DataResultSet.ValueType.DATE;
        }
        return DataResultSet.ValueType.STRING;
    }

    @Override
    public int getCurrentRow() {
        return this.currentRow;
    }
}

