/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.nio.model;

import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.nio.ImportWizardUtils;
import com.rapidminer.operator.nio.model.DataResultSet;
import com.rapidminer.operator.nio.model.ParseException;
import com.rapidminer.tools.ProgressListener;
import java.util.LinkedList;
import javax.swing.table.AbstractTableModel;

public class DefaultPreview
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[][] data;
    private String[] columnNames;
    private int previewSize = ImportWizardUtils.getPreviewLength();

    public DefaultPreview(DataResultSet resultSet, ProgressListener l) throws OperatorException, ParseException {
        this.read(resultSet, l);
    }

    public void read(DataResultSet resultSet, ProgressListener listener) throws OperatorException, ParseException {
        if (listener != null) {
            listener.setTotal(this.previewSize);
        }
        LinkedList<String[]> dataList = new LinkedList<String[]>();
        resultSet.reset(listener);
        while (resultSet.hasNext() && dataList.size() < this.previewSize) {
            resultSet.next(listener);
            String[] row = new String[resultSet.getNumberOfColumns()];
            for (int i = 0; i < row.length; ++i) {
                row[i] = resultSet.getString(i);
            }
            dataList.add(row);
            if (listener == null) continue;
            listener.setCompleted(dataList.size());
        }
        this.data = (String[][])dataList.toArray((T[])new String[dataList.size()][]);
        this.columnNames = resultSet.getColumnNames();
        if (listener != null) {
            listener.complete();
        }
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public int getColumnCount() {
        if (this.columnNames != null) {
            return this.columnNames.length;
        }
        if (this.data != null || this.data.length > 0) {
            return this.data[0].length;
        }
        return 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String[] row = this.data[rowIndex];
        if (row == null) {
            return null;
        }
        if (columnIndex >= row.length) {
            return null;
        }
        return row[columnIndex];
    }
}

