/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.nio.model;

import com.rapidminer.RapidMiner;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeTypeException;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.nio.ImportWizardUtils;
import com.rapidminer.operator.nio.model.ColumnMetaData;
import com.rapidminer.operator.nio.model.DataResultSet;
import com.rapidminer.operator.nio.model.DataResultSetTranslationConfiguration;
import com.rapidminer.operator.nio.model.ParseException;
import com.rapidminer.operator.nio.model.ParsingError;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.container.Pair;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DataResultSetTranslator {
    private boolean shouldStop = false;
    private boolean isReading = false;
    private boolean cancelGuessingRequested = false;
    private boolean cancelLoadingRequested = false;
    private final Map<Pair<Integer, Integer>, ParsingError> errors = new HashMap<Pair<Integer, Integer>, ParsingError>();
    private Operator operator;

    public DataResultSetTranslator(Operator operator) {
        this.operator = operator;
    }

    public ExampleSet read(DataResultSet dataResultSet, DataResultSetTranslationConfiguration configuration, boolean previewOnly, ProgressListener listener) throws OperatorException {
        ColumnMetaData cmd;
        int maxRows = previewOnly ? ImportWizardUtils.getPreviewLength() : -1;
        this.cancelLoadingRequested = false;
        boolean isFaultTolerant = configuration.isFaultTolerant();
        this.isReading = true;
        int[] attributeColumns = configuration.getSelectedIndices();
        int numberOfAttributes = attributeColumns.length;
        Attribute[] attributes = new Attribute[numberOfAttributes];
        for (int i = 0; i < attributes.length; ++i) {
            int attributeValueType = configuration.getColumnMetaData(attributeColumns[i]).getAttributeValueType();
            if (attributeValueType == 0) {
                attributeValueType = 7;
            }
            attributes[i] = AttributeFactory.createAttribute(configuration.getColumnMetaData(attributeColumns[i]).getOriginalAttributeName(), attributeValueType);
        }
        MemoryExampleTable exampleTable = new MemoryExampleTable(attributes);
        int exampleIndex = 0;
        dataResultSet.reset(listener);
        DataRowFactory factory = new DataRowFactory(configuration.getDataManagementType(), '.');
        int maxAnnotatedRow = configuration.getLastAnnotatedRowIndex();
        for (int currentRow = 0; !(!dataResultSet.hasNext() || this.shouldStop || currentRow >= maxRows && maxRows >= 0 || this.cancelLoadingRequested); ++currentRow) {
            dataResultSet.next(listener);
            String currentAnnotation = currentRow <= maxAnnotatedRow ? configuration.getAnnotation(currentRow) : null;
            if (currentAnnotation != null) {
                int attributeIndex = 0;
                for (Attribute attribute : attributes) {
                    if ("Name".equals(currentAnnotation)) {
                        String newAttributeName = this.getString(dataResultSet, exampleIndex, attributeColumns[attributeIndex], isFaultTolerant);
                        if (newAttributeName != null && !newAttributeName.isEmpty()) {
                            attribute.setName(newAttributeName);
                            cmd = configuration.getColumnMetaData(attributeColumns[attributeIndex]);
                            if (cmd != null && !cmd.isAttributeNameSpecified()) {
                                cmd.setUserDefinedAttributeName(newAttributeName);
                            }
                        }
                    } else {
                        String annotationValue = this.getString(dataResultSet, exampleIndex, attributeColumns[attributeIndex], isFaultTolerant);
                        if (annotationValue != null && !annotationValue.isEmpty()) {
                            attribute.getAnnotations().put(currentAnnotation, annotationValue);
                        }
                    }
                    ++attributeIndex;
                }
                continue;
            }
            DataRow row = factory.create(attributes.length);
            exampleTable.addDataRow(row);
            int attributeIndex = 0;
            for (Attribute attribute : attributes) {
                if (dataResultSet.isMissing(attributeColumns[attributeIndex])) {
                    row.set(attribute, Double.NaN);
                } else {
                    switch (attribute.getValueType()) {
                        case 3: {
                            row.set(attribute, this.getOrParseNumber(configuration, dataResultSet, exampleIndex, attributeColumns[attributeIndex], isFaultTolerant));
                            break;
                        }
                        case 2: 
                        case 4: {
                            row.set(attribute, this.getOrParseNumber(configuration, dataResultSet, exampleIndex, attributeColumns[attributeIndex], isFaultTolerant));
                            break;
                        }
                        case 9: 
                        case 10: 
                        case 11: {
                            row.set(attribute, this.getOrParseDate(configuration, dataResultSet, exampleIndex, attributeColumns[attributeIndex], isFaultTolerant));
                            break;
                        }
                        default: {
                            row.set(attribute, this.getStringIndex(attribute, dataResultSet, exampleIndex, attributeColumns[attributeIndex], isFaultTolerant));
                        }
                    }
                }
                ++attributeIndex;
            }
            ++exampleIndex;
        }
        ExampleSet exampleSet = exampleTable.createExampleSet();
        Attributes exampleSetAttributes = exampleSet.getAttributes();
        int attributeIndex = 0;
        for (Attribute attribute : attributes) {
            String roleId;
            cmd = configuration.getColumnMetaData(attributeColumns[attributeIndex]);
            if (!cmd.isSelected()) {
                ++attributeIndex;
                continue;
            }
            String userDefinedName = cmd.getUserDefinedAttributeName();
            if (userDefinedName != null) {
                attribute.setName(userDefinedName);
            }
            if (!"attribute".equals(roleId = cmd.getRole())) {
                exampleSetAttributes.setSpecialAttribute(attribute, roleId);
            }
            ++attributeIndex;
        }
        this.isReading = false;
        if (listener != null) {
            listener.complete();
        }
        return exampleSet;
    }

    private double getOrParseDate(DataResultSetTranslationConfiguration config, DataResultSet dataResultSet, int row, int column, boolean isFaultTolerant) throws OperatorException {
        DataResultSet.ValueType nativeValueType;
        try {
            nativeValueType = dataResultSet.getNativeValueType(column);
        }
        catch (ParseException e1) {
            this.addOrThrow(isFaultTolerant, e1.getError(), row);
            return Double.NaN;
        }
        if (nativeValueType == DataResultSet.ValueType.DATE) {
            return this.getDate(dataResultSet, row, column, isFaultTolerant);
        }
        String value = this.getString(dataResultSet, row, column, isFaultTolerant);
        try {
            return config.getDateFormat().parse(value).getTime();
        }
        catch (java.text.ParseException e) {
            ParsingError error = new ParsingError(dataResultSet.getCurrentRow(), column, ParsingError.ErrorCode.UNPARSEABLE_DATE, value, e);
            this.addOrThrow(isFaultTolerant, error, row);
            return Double.NaN;
        }
    }

    private double getDate(DataResultSet dataResultSet, int row, int column, boolean isFaultTolerant) throws OperatorException {
        try {
            return dataResultSet.getDate(column).getTime();
        }
        catch (ParseException e) {
            this.addOrThrow(isFaultTolerant, e.getError(), row);
            return Double.NaN;
        }
    }

    private double getStringIndex(Attribute attribute, DataResultSet dataResultSet, int row, int column, boolean isFaultTolerant) throws UserError {
        String value = null;
        try {
            value = dataResultSet.getString(column);
            int mapIndex = attribute.getMapping().mapString(value);
            return mapIndex;
        }
        catch (ParseException e) {
            this.addOrThrow(isFaultTolerant, e.getError(), row);
            return Double.NaN;
        }
        catch (AttributeTypeException e) {
            ParsingError error = new ParsingError(dataResultSet.getCurrentRow(), column, ParsingError.ErrorCode.MORE_THAN_TWO_VALUES, value, e);
            this.addOrThrow(isFaultTolerant, error, row);
            return Double.NaN;
        }
    }

    private String getString(DataResultSet dataResultSet, int row, int column, boolean isFaultTolerant) throws UserError {
        try {
            return dataResultSet.getString(column);
        }
        catch (ParseException e) {
            this.addOrThrow(isFaultTolerant, e.getError(), row);
            return null;
        }
    }

    private double getOrParseNumber(DataResultSetTranslationConfiguration config, DataResultSet dataResultSet, int row, int column, boolean isFaultTolerant) throws OperatorException {
        DataResultSet.ValueType nativeValueType;
        try {
            nativeValueType = dataResultSet.getNativeValueType(column);
        }
        catch (ParseException e1) {
            this.addOrThrow(isFaultTolerant, e1.getError(), row);
            return Double.NaN;
        }
        if (nativeValueType == DataResultSet.ValueType.NUMBER) {
            return this.getNumber(dataResultSet, row, column, isFaultTolerant).doubleValue();
        }
        String value = this.getString(dataResultSet, row, column, isFaultTolerant);
        NumberFormat numberFormat = config.getNumberFormat();
        if (numberFormat != null) {
            try {
                Number parsedValue = numberFormat.parse(value);
                return parsedValue.doubleValue();
            }
            catch (java.text.ParseException e) {
                ParsingError error = new ParsingError(dataResultSet.getCurrentRow(), column, ParsingError.ErrorCode.UNPARSEABLE_REAL, value, e);
                this.addOrThrow(isFaultTolerant, error, row);
                return Double.NaN;
            }
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            ParsingError error = new ParsingError(dataResultSet.getCurrentRow(), column, ParsingError.ErrorCode.UNPARSEABLE_REAL, value, e);
            this.addOrThrow(isFaultTolerant, error, row);
            return Double.NaN;
        }
    }

    private Number getNumber(DataResultSet dataResultSet, int row, int column, boolean isFaultTolerant) throws OperatorException {
        try {
            return dataResultSet.getNumber(column);
        }
        catch (ParseException e) {
            if (isFaultTolerant) {
                this.addError(e.getError(), row);
                return Double.NaN;
            }
            throw new UserError(this.operator, "data_parsing_error", e.toString());
        }
    }

    public void guessValueTypes(DataResultSetTranslationConfiguration configuration, DataResultSet dataResultSet, ProgressListener listener) throws OperatorException {
        int maxProbeRows;
        try {
            maxProbeRows = Integer.parseInt(RapidMiner.getRapidMinerPropertyValue("rapidminer.general.max_rows_used_for_guessing"));
        }
        catch (NumberFormatException e) {
            maxProbeRows = 100;
        }
        this.guessValueTypes(configuration, dataResultSet, maxProbeRows, listener);
    }

    public void guessValueTypes(DataResultSetTranslationConfiguration configuration, DataResultSet dataResultSet, int maxNumberOfRows, ProgressListener listener) throws OperatorException {
        int[] originalValueTypes = new int[configuration.getNumerOfColumns()];
        for (int i = 0; i < originalValueTypes.length; ++i) {
            originalValueTypes[i] = configuration.getColumnMetaData(i).getAttributeValueType();
        }
        int[] guessedTypes = this.guessValueTypes(originalValueTypes, configuration, dataResultSet, maxNumberOfRows, listener);
        for (int i = 0; i < guessedTypes.length; ++i) {
            configuration.getColumnMetaData(i).setAttributeValueType(guessedTypes[i]);
        }
    }

    private int[] guessValueTypes(int[] definedTypes, DataResultSetTranslationConfiguration configuration, DataResultSet dataResultSet, int maxProbeRows, ProgressListener listener) throws OperatorException {
        this.cancelGuessingRequested = false;
        if (listener != null) {
            listener.setTotal(1 + maxProbeRows);
        }
        DateFormat dateFormat = configuration.getDateFormat();
        NumberFormat numberFormat = configuration.getNumberFormat();
        if (listener != null) {
            listener.setCompleted(1);
        }
        int[] columnValueTypes = new int[dataResultSet.getNumberOfColumns()];
        Arrays.fill(columnValueTypes, 3);
        dataResultSet.reset(listener);
        int currentRow = 0;
        int exampleIndex = 0;
        NominalValueSet[] nominalValues = new NominalValueSet[dataResultSet.getNumberOfColumns()];
        for (int i = 0; i < nominalValues.length; ++i) {
            nominalValues[i] = new NominalValueSet();
        }
        int maxAnnotatedRow = configuration.getLastAnnotatedRowIndex();
        while (dataResultSet.hasNext() && (currentRow < maxProbeRows || maxProbeRows <= 0) && !this.cancelGuessingRequested) {
            dataResultSet.next(listener);
            if (listener != null) {
                listener.setCompleted(1 + currentRow);
            }
            if (currentRow > maxAnnotatedRow || configuration.getAnnotation(currentRow) == null) {
                int numCols = dataResultSet.getNumberOfColumns();
                if (numCols > definedTypes.length) {
                    String excessString;
                    try {
                        excessString = dataResultSet.getString(definedTypes.length);
                    }
                    catch (ParseException e) {
                        excessString = null;
                    }
                    this.addError(new ParsingError(dataResultSet.getCurrentRow(), 0, ParsingError.ErrorCode.ROW_TOO_LONG, excessString, null), exampleIndex);
                }
                for (int column = 0; column < definedTypes.length; ++column) {
                    String stringRepresentation;
                    DataResultSet.ValueType nativeType;
                    if (definedTypes[column] == 7 || dataResultSet.isMissing(column)) continue;
                    try {
                        nativeType = dataResultSet.getNativeValueType(column);
                        stringRepresentation = dataResultSet.getString(column);
                    }
                    catch (ParseException e) {
                        ParsingError error = e.getError();
                        this.addError(error, exampleIndex);
                        continue;
                    }
                    nominalValues[column].register(stringRepresentation);
                    if (nativeType != DataResultSet.ValueType.STRING) {
                        Number value;
                        int isType = nativeType.getRapidMinerAttributeType();
                        if (nativeType == DataResultSet.ValueType.NUMBER && !Double.isNaN((value = this.getNumber(dataResultSet, exampleIndex, column, true)).doubleValue())) {
                            isType = (double)value.intValue() == value.doubleValue() ? 3 : 4;
                        }
                        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(isType, definedTypes[column])) {
                            if (definedTypes[column] != 0) continue;
                            definedTypes[column] = isType;
                            continue;
                        }
                        while (!Ontology.ATTRIBUTE_VALUE_TYPE.isA(isType, definedTypes[column])) {
                            definedTypes[column] = Ontology.ATTRIBUTE_VALUE_TYPE.getParent(definedTypes[column]);
                        }
                        if (definedTypes[column] != 0) continue;
                        definedTypes[column] = nominalValues[column].moreThanTwo ? 7 : 6;
                        continue;
                    }
                    definedTypes[column] = this.guessValueType(definedTypes[column], stringRepresentation, !nominalValues[column].moreThanTwo, dateFormat, numberFormat);
                }
                ++exampleIndex;
            }
            ++currentRow;
        }
        if (listener != null) {
            listener.complete();
        }
        return definedTypes;
    }

    private int guessValueType(int currentValueType, String value, boolean onlyTwoValues, DateFormat dateFormat, NumberFormat numberFormat) {
        if (currentValueType == 7) {
            return currentValueType;
        }
        if (currentValueType == 6) {
            if (onlyTwoValues) {
                return 6;
            }
            return 7;
        }
        if (currentValueType == 10) {
            try {
                dateFormat.parse(value);
                return currentValueType;
            }
            catch (java.text.ParseException e) {
                return this.guessValueType(6, value, onlyTwoValues, dateFormat, numberFormat);
            }
        }
        if (currentValueType == 4) {
            if (numberFormat != null) {
                try {
                    numberFormat.parse(value);
                    return currentValueType;
                }
                catch (java.text.ParseException e) {
                    return this.guessValueType(10, value, onlyTwoValues, dateFormat, numberFormat);
                }
            }
            try {
                Double.parseDouble(value);
                return currentValueType;
            }
            catch (NumberFormatException e) {
                return this.guessValueType(10, value, onlyTwoValues, dateFormat, null);
            }
        }
        try {
            Integer.parseInt(value);
            return 3;
        }
        catch (NumberFormatException e) {
            return this.guessValueType(4, value, onlyTwoValues, dateFormat, numberFormat);
        }
    }

    public void close() throws OperatorException {
        if (this.isReading) {
            this.shouldStop = true;
            this.shouldStop = false;
        }
    }

    public void clearErrors() {
        this.errors.clear();
    }

    private void addOrThrow(boolean isFaultTolerant, ParsingError error, int row) throws UserError {
        if (!isFaultTolerant) {
            throw new UserError(this.operator, 403, error.toString());
        }
        this.addError(error, row);
    }

    private void addError(ParsingError error, int exampleIndex) {
        error.setExampleIndex(exampleIndex);
        this.errors.put(new Pair<Integer, Integer>(error.getExampleIndex(), error.getColumn()), error);
    }

    public Collection<ParsingError> getErrors() {
        return this.errors.values();
    }

    public ParsingError getErrorByExampleIndexAndColumn(int row, int column) {
        if (this.errors == null) {
            return null;
        }
        return this.errors.get(new Pair<Integer, Integer>(row, column));
    }

    public void cancelGuessing() {
        this.cancelGuessingRequested = true;
    }

    public void cancelLoading() {
        this.cancelLoadingRequested = true;
    }

    public boolean isGuessingCancelled() {
        return this.cancelGuessingRequested;
    }

    private class NominalValueSet {
        private String first = null;
        private String second = null;
        private boolean moreThanTwo = false;

        private NominalValueSet() {
        }

        private boolean register(String value) {
            if (this.moreThanTwo) {
                return true;
            }
            if (value == null) {
                return false;
            }
            if (this.first == null) {
                this.first = value;
                return false;
            }
            if (this.first.equals(value)) {
                return false;
            }
            if (this.second == null) {
                this.second = value;
                return false;
            }
            if (this.second.equals(value)) {
                return false;
            }
            this.moreThanTwo = true;
            return true;
        }
    }
}

