/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.nio.model;

import com.rapidminer.operator.nio.model.AbstractDataResultSetReader;
import com.rapidminer.operator.nio.model.ColumnMetaData;
import com.rapidminer.operator.nio.model.DataResultSet;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.preprocessing.filter.AbstractDateDataProcessing;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeTupel;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.Ontology;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class DataResultSetTranslationConfiguration {
    private ColumnMetaData[] columnMetaData;
    private Locale locale = Locale.getDefault();
    private String datePattern = "";
    private final SortedMap<Integer, String> annotationsMap = new TreeMap<Integer, String>();
    private boolean faultTolerant = true;
    private DateFormat dateFormat;
    private NumberFormat numberFormat;
    private int dataManagementType = 0;

    public DataResultSetTranslationConfiguration(AbstractDataResultSetReader readerOperator) {
        this(readerOperator, null);
    }

    private DataResultSetTranslationConfiguration(AbstractDataResultSetReader readerOperator, DataResultSet dataResultSet) {
        this.reconfigure(dataResultSet);
        this.reconfigure(readerOperator);
    }

    /*
     * WARNING - void declaration
     */
    public void reconfigure(AbstractDataResultSetReader readerOperator) {
        if (readerOperator != null) {
            void var4_15;
            List<Object> annotations;
            try {
                this.dataManagementType = readerOperator.getParameterAsInt("datamanagement");
            }
            catch (UndefinedParameterError e1) {
                this.dataManagementType = 0;
            }
            try {
                annotations = readerOperator.getParameterList("annotations");
            }
            catch (UndefinedParameterError e) {
                annotations = Collections.emptyList();
            }
            for (String[] stringArray : annotations) {
                this.annotationsMap.put(Integer.parseInt(stringArray[0]), stringArray[1]);
            }
            boolean firstRowAsNames = readerOperator.getParameterAsBoolean("first_row_as_names");
            if (firstRowAsNames) {
                this.annotationsMap.put(0, "Name");
            }
            try {
                this.setDatePattern(readerOperator.getParameterAsString("date_format"));
            }
            catch (UndefinedParameterError undefinedParameterError) {
                this.setDatePattern("");
            }
            try {
                int n = readerOperator.getParameterAsInt("locale");
                if (n >= 0 && n < AbstractDateDataProcessing.availableLocales.size()) {
                    this.locale = AbstractDateDataProcessing.availableLocales.get(n);
                }
            }
            catch (UndefinedParameterError undefinedParameterError) {
                this.locale = Locale.getDefault();
            }
            if (readerOperator.isParameterSet("data_set_meta_data_information")) {
                try {
                    List<String[]> list = readerOperator.getParameterList("data_set_meta_data_information");
                }
                catch (UndefinedParameterError e) {
                    List list = Collections.emptyList();
                }
            } else {
                List list = Collections.emptyList();
            }
            this.columnMetaData = new ColumnMetaData[var4_15.size()];
            for (String[] stringArray : var4_15) {
                int currentColumn = Integer.parseInt(stringArray[0]);
                String[] metaDataDefintionValues = ParameterTypeTupel.transformString2Tupel(stringArray[1]);
                this.columnMetaData[currentColumn] = new ColumnMetaData();
                ColumnMetaData cmd = this.columnMetaData[currentColumn];
                cmd.setSelected(Boolean.parseBoolean(metaDataDefintionValues[1]));
                if (!cmd.isSelected()) continue;
                cmd.setRole(metaDataDefintionValues[3].trim());
                cmd.setUserDefinedAttributeName(metaDataDefintionValues[0].trim());
                int valueType = Ontology.ATTRIBUTE_VALUE_TYPE.mapName(metaDataDefintionValues[2]);
                if (valueType == -1) {
                    cmd.setAttributeValueType(Integer.parseInt(metaDataDefintionValues[2]));
                    continue;
                }
                cmd.setAttributeValueType(valueType);
            }
            this.setFaultTolerant(readerOperator.getParameterAsBoolean("read_not_matching_values_as_missings"));
        }
    }

    public void reconfigure(DataResultSet dataResultSet) {
        if (dataResultSet != null) {
            int numberOfColumns = dataResultSet.getNumberOfColumns();
            this.columnMetaData = new ColumnMetaData[numberOfColumns];
            String[] originalColumnNames = dataResultSet.getColumnNames();
            int[] attributeValueTypes = dataResultSet.getValueTypes();
            for (int i = 0; i < numberOfColumns; ++i) {
                this.columnMetaData[i] = new ColumnMetaData(originalColumnNames[i], originalColumnNames[i], attributeValueTypes[i], "attribute", true);
            }
        }
    }

    public void setParameters(AbstractDataResultSetReader operator) {
        operator.getParameters().setParameter("date_format", this.getDatePattern());
        LinkedList<String[]> metaDataList = new LinkedList<String[]>();
        int index = 0;
        for (ColumnMetaData cmd : this.getColumnMetaData()) {
            String[] tupel = new String[]{cmd.getUserDefinedAttributeName(), String.valueOf(cmd.isSelected()), Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(cmd.getAttributeValueType()), cmd.getRole()};
            String encodedTupel = ParameterTypeTupel.transformTupel2String(tupel);
            metaDataList.add(new String[]{String.valueOf(index), encodedTupel});
            ++index;
        }
        operator.getParameters().setParameter("data_set_meta_data_information", ParameterTypeList.transformList2String(metaDataList));
        LinkedList<String[]> annotationList = new LinkedList<String[]>();
        for (Map.Entry<Integer, String> annotation : this.annotationsMap.entrySet()) {
            annotationList.add(new String[]{annotation.getKey().toString(), annotation.getValue()});
        }
        operator.setParameter("annotations", ParameterTypeList.transformList2String(annotationList));
        operator.getParameters().setParameter("read_not_matching_values_as_missings", String.valueOf(this.isFaultTolerant()));
        operator.getParameters().setParameter("first_row_as_names", "false");
    }

    public ColumnMetaData getColumnMetaData(int col) {
        if (this.columnMetaData != null && col < this.columnMetaData.length) {
            return this.columnMetaData[col];
        }
        return null;
    }

    public int[] getSelectedIndices() {
        int numberOfSelected = 0;
        int[] selectedIndices = new int[this.columnMetaData.length];
        for (int i = 0; i < selectedIndices.length; ++i) {
            if (!this.columnMetaData[i].isSelected()) continue;
            selectedIndices[numberOfSelected] = i;
            ++numberOfSelected;
        }
        if (numberOfSelected < selectedIndices.length) {
            int[] result = new int[numberOfSelected];
            System.arraycopy(selectedIndices, 0, result, 0, numberOfSelected);
            return result;
        }
        return selectedIndices;
    }

    public String getAnnotation(int line) {
        return (String)this.annotationsMap.get(line);
    }

    public SortedSet<Integer> getAnnotatedRowIndices() {
        TreeSet<Integer> result = new TreeSet<Integer>();
        result.addAll(this.annotationsMap.keySet());
        return result;
    }

    public Map<Integer, String> getAnnotationsMap() {
        return this.annotationsMap;
    }

    public int getNameRow() {
        if (this.annotationsMap == null) {
            return -1;
        }
        for (Map.Entry<Integer, String> entry : this.annotationsMap.entrySet()) {
            if (!"Name".equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return -1;
    }

    public int getNumerOfColumns() {
        return this.columnMetaData.length;
    }

    public ColumnMetaData[] getColumnMetaData() {
        return this.columnMetaData;
    }

    public void setFaultTolerant(boolean faultTolerant) {
        this.faultTolerant = faultTolerant;
    }

    public boolean isFaultTolerant() {
        return this.faultTolerant;
    }

    public int getLastAnnotatedRowIndex() {
        if (this.annotationsMap == null || this.annotationsMap.isEmpty()) {
            return -1;
        }
        SortedSet<Integer> annotatedRows = this.getAnnotatedRowIndices();
        return annotatedRows.last();
    }

    public void resetValueTypes() {
        for (ColumnMetaData cmd : this.columnMetaData) {
            cmd.setAttributeValueType(0);
        }
    }

    public DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = this.getDatePattern() != null && !this.getDatePattern().isEmpty() ? new SimpleDateFormat(this.getDatePattern(), this.locale) : DateFormat.getDateTimeInstance();
        }
        return this.dateFormat;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
        this.dateFormat = null;
    }

    public String toString() {
        return "Annotations: " + this.annotationsMap + "; columns: " + Arrays.toString(this.columnMetaData);
    }

    public void addColumnMetaData(ExampleSetMetaData emd) {
        MDInteger numberOfExamples = emd.getNumberOfExamples();
        numberOfExamples.subtract(this.annotationsMap.size());
        for (ColumnMetaData cmd : this.columnMetaData) {
            emd.addAttribute(cmd.getAttributeMetaData());
        }
    }

    public boolean isComplete() {
        return this.columnMetaData != null && this.columnMetaData.length > 0;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public int getDataManagementType() {
        return this.dataManagementType;
    }
}

