/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.nio.model;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.nio.CSVExampleSource;
import com.rapidminer.operator.nio.model.AbstractDataResultSetReader;
import com.rapidminer.operator.nio.model.CSVResultSet;
import com.rapidminer.operator.nio.model.DataResultSet;
import com.rapidminer.operator.nio.model.DataResultSetFactory;
import com.rapidminer.operator.nio.model.DefaultPreview;
import com.rapidminer.operator.nio.model.ParseException;
import com.rapidminer.operator.nio.model.ParsingError;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.io.Encoding;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import javax.swing.table.TableModel;

public class CSVResultSetConfiguration
implements DataResultSetFactory {
    private String csvFile;
    private boolean skipComments = true;
    private boolean useQuotes = true;
    private boolean trimLines = false;
    private String columnSeparators = ";";
    private char quoteCharacter = (char)34;
    private char escapeCharacter = (char)92;
    private String commentCharacters = "#";
    private Charset encoding = Charset.defaultCharset();
    private List<ParsingError> errors;

    public CSVResultSetConfiguration() {
    }

    public CSVResultSetConfiguration(CSVExampleSource csvExampleSource) throws OperatorException {
        if (csvExampleSource.isParameterSet("csv_file")) {
            this.setCsvFile(csvExampleSource.getParameterAsString("csv_file"));
        }
        this.setSkipComments(csvExampleSource.getParameterAsBoolean("skip_comments"));
        this.setUseQuotes(csvExampleSource.getParameterAsBoolean("use_quotes"));
        this.setTrimLines(csvExampleSource.getParameterAsBoolean("trim_lines"));
        if (csvExampleSource.isParameterSet("column_separators")) {
            this.setColumnSeparators(csvExampleSource.getParameterAsString("column_separators"));
        }
        if (csvExampleSource.isParameterSet("escape_character_for_quotes")) {
            this.setEscapeCharacter(csvExampleSource.getParameterAsChar("escape_character_for_quotes"));
        }
        if (csvExampleSource.isParameterSet("comment_characters")) {
            this.setCommentCharacters(csvExampleSource.getParameterAsString("comment_characters"));
        }
        if (csvExampleSource.isParameterSet("quotes_character")) {
            this.setQuoteCharacter(csvExampleSource.getParameterAsChar("quotes_character"));
        }
        this.encoding = Encoding.getEncoding(csvExampleSource);
    }

    @Override
    public void setParameters(AbstractDataResultSetReader source) {
        source.setParameter("csv_file", this.getCsvFile());
        source.setParameter("skip_comments", String.valueOf(this.isSkipComments()));
        source.setParameter("use_quotes", String.valueOf(this.isUseQuotes()));
        source.setParameter("column_separators", this.getColumnSeparators());
        source.setParameter("trim_lines", String.valueOf(this.isTrimLines()));
        source.setParameter("quotes_character", String.valueOf(this.getQuoteCharacter()));
        source.setParameter("escape_character_for_quotes", String.valueOf(this.getEscapeCharacter()));
        source.setParameter("comment_characters", this.getCommentCharacters());
    }

    @Override
    public DataResultSet makeDataResultSet(Operator operator) throws OperatorException {
        return new CSVResultSet(this, operator);
    }

    @Override
    public TableModel makePreviewTableModel(ProgressListener listener) throws OperatorException, ParseException {
        DataResultSet resultSet = this.makeDataResultSet(null);
        this.errors = ((CSVResultSet)resultSet).getErrors();
        return new DefaultPreview(resultSet, listener);
    }

    public void setCsvFile(String csvFile) {
        this.csvFile = csvFile;
    }

    public String getCsvFile() {
        return this.csvFile;
    }

    public File getCsvFileAsFile() {
        return this.csvFile == null ? null : new File(this.csvFile);
    }

    public void setUseQuotes(boolean useQuotes) {
        this.useQuotes = useQuotes;
    }

    public boolean isUseQuotes() {
        return this.useQuotes;
    }

    public void setSkipComments(boolean skipComments) {
        this.skipComments = skipComments;
    }

    public boolean isSkipComments() {
        return this.skipComments;
    }

    public void setColumnSeparators(String columnSeparators) {
        this.columnSeparators = columnSeparators;
    }

    public String getColumnSeparators() {
        return this.columnSeparators;
    }

    public void setCommentCharacters(String commentCharacters) {
        this.commentCharacters = commentCharacters;
    }

    public String getCommentCharacters() {
        return this.commentCharacters;
    }

    public void setEscapeCharacter(char escapeCharacter) {
        this.escapeCharacter = escapeCharacter;
    }

    public char getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public void setQuoteCharacter(char quoteCharacter) {
        this.quoteCharacter = quoteCharacter;
    }

    public char getQuoteCharacter() {
        return this.quoteCharacter;
    }

    public void setTrimLines(boolean trimLines) {
        this.trimLines = trimLines;
    }

    public boolean isTrimLines() {
        return this.trimLines;
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    @Override
    public String getResourceName() {
        return this.getCsvFile();
    }

    @Override
    public ExampleSetMetaData makeMetaData() {
        return new ExampleSetMetaData();
    }

    public List<ParsingError> getErrors() {
        return this.errors;
    }

    @Override
    public void close() {
    }
}

