/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.nio.model;

import com.rapidminer.gui.tools.dialogs.wizards.dataimport.csv.LineReader;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.nio.model.CSVResultSetConfiguration;
import com.rapidminer.operator.nio.model.DataResultSet;
import com.rapidminer.operator.nio.model.ParseException;
import com.rapidminer.operator.nio.model.ParsingError;
import com.rapidminer.tools.CSVParseException;
import com.rapidminer.tools.LineParser;
import com.rapidminer.tools.ProgressListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class CSVResultSet
implements DataResultSet {
    private CSVResultSetConfiguration configuration;
    private LineReader reader;
    private LineParser parser;
    private String[] next;
    private String[] current;
    private int currentRow;
    private String[] columnNames;
    private int[] valueTypes;
    private int numColumns = 0;
    private Operator operator;
    private final List<ParsingError> errors = new LinkedList<ParsingError>();

    public CSVResultSet(CSVResultSetConfiguration configuration, Operator operator) throws OperatorException {
        this.configuration = configuration;
        this.operator = operator;
        this.open();
    }

    private void open() throws OperatorException {
        InputStream in;
        this.getErrors().clear();
        this.close();
        try {
            URL url = new URL(this.configuration.getCsvFile());
            try {
                in = url.openStream();
            }
            catch (IOException e) {
                throw new UserError(this.operator, 301, e, this.configuration.getCsvFile());
            }
        }
        catch (MalformedURLException e) {
            try {
                in = new FileInputStream(this.configuration.getCsvFile());
            }
            catch (FileNotFoundException e1) {
                throw new UserError(this.operator, 301, e1, this.configuration.getCsvFile());
            }
        }
        this.reader = new LineReader(in, this.configuration.getEncoding());
        this.parser = new LineParser(this.configuration);
        try {
            this.readNext();
        }
        catch (IOException e) {
            throw new UserError(this.operator, (Throwable)e, 321, this.configuration.getCsvFile(), e.toString());
        }
        if (this.next == null) {
            this.errors.add(new ParsingError(1, -1, ParsingError.ErrorCode.FILE_SYNTAX_ERROR, "No valid line found."));
            this.columnNames = new String[0];
            this.valueTypes = new int[0];
        } else {
            this.columnNames = new String[this.next.length];
            for (int i = 0; i < this.next.length; ++i) {
                this.columnNames[i] = "att" + (i + 1);
            }
            this.valueTypes = new int[this.next.length];
            Arrays.fill(this.valueTypes, 1);
            this.currentRow = -1;
        }
    }

    private void readNext() throws IOException {
        while (true) {
            String line;
            if ((line = this.reader.readLine()) == null) {
                this.next = null;
                return;
            }
            try {
                this.next = this.parser.parse(line);
                if (this.next == null) continue;
            }
            catch (CSVParseException e) {
                this.getErrors().add(new ParsingError(this.currentRow, -1, ParsingError.ErrorCode.FILE_SYNTAX_ERROR, line, e));
                this.next = new String[]{line};
                continue;
            }
            break;
        }
        this.numColumns = Math.max(this.numColumns, this.next.length);
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public void next(ProgressListener listener) throws OperatorException {
        this.current = this.next;
        ++this.currentRow;
        try {
            this.readNext();
        }
        catch (IOException e) {
            throw new UserError(this.operator, (Throwable)e, 321, this.configuration.getCsvFile(), e.toString());
        }
    }

    @Override
    public int getNumberOfColumns() {
        if (this.current != null) {
            return this.current.length;
        }
        return this.numColumns;
    }

    @Override
    public String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    public boolean isMissing(int columnIndex) {
        return columnIndex >= this.current.length || this.current[columnIndex] == null || this.current[columnIndex].isEmpty();
    }

    @Override
    public Number getNumber(int columnIndex) throws ParseException {
        throw new ParseException(new ParsingError(this.currentRow, columnIndex, ParsingError.ErrorCode.UNPARSEABLE_REAL, this.current[columnIndex]));
    }

    @Override
    public String getString(int columnIndex) throws ParseException {
        if (columnIndex < this.current.length) {
            return this.current[columnIndex];
        }
        return null;
    }

    @Override
    public Date getDate(int columnIndex) throws ParseException {
        throw new ParseException(new ParsingError(this.currentRow, columnIndex, ParsingError.ErrorCode.UNPARSEABLE_DATE, this.current[columnIndex]));
    }

    @Override
    public DataResultSet.ValueType getNativeValueType(int columnIndex) throws ParseException {
        return DataResultSet.ValueType.STRING;
    }

    @Override
    public void close() throws OperatorException {
        if (this.reader == null) {
            return;
        }
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new UserError(this.operator, 321, e, this.configuration.getCsvFile(), e.toString());
        }
        finally {
            this.reader = null;
        }
    }

    @Override
    public void reset(ProgressListener listener) throws OperatorException {
        this.open();
    }

    @Override
    public int[] getValueTypes() {
        return this.valueTypes;
    }

    @Override
    public int getCurrentRow() {
        return this.currentRow;
    }

    public List<ParsingError> getErrors() {
        return this.errors;
    }
}

