/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.nio;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.wizards.AbstractWizard;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.RepositoryLocationSelectionWizardStep;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.nio.model.DataResultSet;
import com.rapidminer.operator.nio.model.WizardState;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.RepositoryManager;
import com.rapidminer.tools.LogService;
import java.util.logging.Level;

public final class StoreDataWizardStep
extends RepositoryLocationSelectionWizardStep {
    private WizardState state;

    public StoreDataWizardStep(AbstractWizard parent, WizardState state, String preselectedLocation) {
        super(parent, preselectedLocation);
        this.state = state;
    }

    @Override
    protected boolean performLeavingAction(AbstractWizard.WizardStepDirection direction) {
        if (direction == AbstractWizard.WizardStepDirection.FINISH) {
            RepositoryLocation location;
            String repositoryLocationPath = this.getRepositoryLocation();
            if (repositoryLocationPath == null) {
                return false;
            }
            try {
                location = new RepositoryLocation(repositoryLocationPath);
            }
            catch (Exception e) {
                SwingTools.showSimpleErrorMessage("malformed_rep_location", (Throwable)e, repositoryLocationPath);
                return false;
            }
            new ProgressThread("importing_data", true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DataResultSet resultSet = null;
                    try {
                        if (StoreDataWizardStep.this.state.getTranslator() != null) {
                            StoreDataWizardStep.this.state.getTranslator().close();
                        }
                        resultSet = StoreDataWizardStep.this.state.getDataResultSetFactory().makeDataResultSet(null);
                        StoreDataWizardStep.this.state.getTranslator().clearErrors();
                        ExampleSet exampleSet = StoreDataWizardStep.this.state.readNow(resultSet, false, this.getProgressListener());
                        try {
                            RepositoryManager.getInstance(null).store(exampleSet, location, null);
                        }
                        catch (RepositoryException ex) {
                            SwingTools.showSimpleErrorMessage("cannot_store_obj_at_location", (Throwable)ex, location);
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (OperatorException e) {
                                    LogService.getRoot().log(Level.WARNING, "Failed to close result set: " + e, e);
                                }
                            }
                            StoreDataWizardStep.this.state.getDataResultSetFactory().close();
                            this.getProgressListener().complete();
                            return;
                        }
                    }
                    catch (Exception e) {
                        SwingTools.showSimpleErrorMessage("cannot_store_obj_at_location", (Throwable)e, location);
                    }
                    finally {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (OperatorException e) {
                                LogService.getRoot().log(Level.WARNING, "Failed to close result set: " + e, e);
                            }
                        }
                        StoreDataWizardStep.this.state.getDataResultSetFactory().close();
                        this.getProgressListener().complete();
                    }
                }
            }.start();
            return true;
        }
        return super.performLeavingAction(direction);
    }
}

