/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.nio;

import java.util.Arrays;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class RowFilteringTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private TableModel wrappedModel;
    private boolean enabled = false;
    private int[] rowMap;

    public RowFilteringTableModel(TableModel wrappedModel, int[] rowMap, boolean enabled) {
        this.rowMap = rowMap;
        this.wrappedModel = wrappedModel;
        this.enabled = enabled;
        wrappedModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                TableModelEvent translated = new TableModelEvent(RowFilteringTableModel.this, RowFilteringTableModel.this.translateRow(e.getFirstRow()), RowFilteringTableModel.this.translateRow(e.getLastRow()), e.getColumn(), e.getType());
                RowFilteringTableModel.this.fireTableChanged(translated);
            }
        });
    }

    protected int translateRow(int row) {
        if (this.enabled) {
            return this.rowMap[row];
        }
        return row;
    }

    protected int inverseTranslateRow(int row) {
        if (this.enabled) {
            return Arrays.binarySearch(this.rowMap, row);
        }
        return row;
    }

    @Override
    public int getRowCount() {
        if (this.enabled) {
            return this.rowMap.length;
        }
        return this.wrappedModel.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.wrappedModel.getColumnCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.wrappedModel.getValueAt(this.translateRow(rowIndex), columnIndex);
    }

    @Override
    public String getColumnName(int column) {
        return this.wrappedModel.getColumnName(column);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.wrappedModel.getColumnClass(columnIndex);
    }

    public void setWrappedModel(TableModel wm, int[] rowMap) {
        int oldSize = this.getRowCount();
        this.wrappedModel = wm;
        this.rowMap = rowMap;
        this.fireChange(oldSize);
    }

    public void setFilterEnabled(boolean enabled) {
        int oldSize = this.getRowCount();
        this.enabled = enabled;
        this.fireChange(oldSize);
    }

    private void fireChange(int oldSize) {
        if (this.getRowCount() > oldSize) {
            this.fireTableRowsInserted(oldSize, this.getRowCount());
        } else {
            this.fireTableRowsDeleted(this.getRowCount(), oldSize);
        }
        this.fireTableDataChanged();
    }
}

