/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.nio;

import com.rapidminer.example.Attributes;
import com.rapidminer.operator.nio.model.ColumnMetaData;
import com.rapidminer.tools.Ontology;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class MetaDataTableHeaderCellEditor
extends JPanel
implements TableCellEditor,
TableCellRenderer {
    private static final long serialVersionUID = 1L;
    private ColumnMetaData value;
    private EventListenerList cellEditorListeners = new EventListenerList();
    private JComboBox valueTypeBox = new JComboBox<String>(Ontology.ATTRIBUTE_VALUE_TYPE.getNames());
    private JCheckBox selectCheckBox = new JCheckBox();
    private JTextField nameField = new JTextField();
    private JComboBox roleBox = new JComboBox<String>(Attributes.KNOWN_ATTRIBUTE_TYPES);

    public MetaDataTableHeaderCellEditor() {
        super(new GridLayout(4, 1));
        this.roleBox.setEditable(true);
        this.add(this.selectCheckBox);
        this.add(this.nameField);
        this.add(this.valueTypeBox);
        this.add(this.roleBox);
        this.valueTypeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MetaDataTableHeaderCellEditor.this.value != null) {
                    MetaDataTableHeaderCellEditor.this.value.setAttributeValueType(MetaDataTableHeaderCellEditor.this.valueTypeBox.getSelectedIndex());
                }
            }
        });
        this.nameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MetaDataTableHeaderCellEditor.this.value != null) {
                    String text = MetaDataTableHeaderCellEditor.this.nameField.getText();
                    if (text != null && !text.isEmpty()) {
                        MetaDataTableHeaderCellEditor.this.value.setUserDefinedAttributeName(text);
                    } else {
                        MetaDataTableHeaderCellEditor.this.nameField.setText(MetaDataTableHeaderCellEditor.this.value.getOriginalAttributeName());
                        MetaDataTableHeaderCellEditor.this.value.setUserDefinedAttributeName(MetaDataTableHeaderCellEditor.this.value.getOriginalAttributeName());
                    }
                }
            }
        });
        this.selectCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MetaDataTableHeaderCellEditor.this.value != null) {
                    MetaDataTableHeaderCellEditor.this.value.setSelected(MetaDataTableHeaderCellEditor.this.selectCheckBox.isSelected());
                }
            }
        });
        this.roleBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MetaDataTableHeaderCellEditor.this.value != null) {
                    MetaDataTableHeaderCellEditor.this.value.setRole(MetaDataTableHeaderCellEditor.this.roleBox.getSelectedItem().toString());
                }
            }
        });
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        if (this.value != null) {
            this.value.setUserDefinedAttributeName(this.nameField.getText());
        }
        this.fireEditingStopped();
        return true;
    }

    private void fireEditingStopped() {
        CellEditorListener[] listeners = (CellEditorListener[])this.listenerList.getListeners(CellEditorListener.class);
        ChangeEvent changeEvent = null;
        for (CellEditorListener l : listeners) {
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            l.editingStopped(changeEvent);
        }
    }

    private void fireEditingCancelled() {
        CellEditorListener[] listeners = (CellEditorListener[])this.listenerList.getListeners(CellEditorListener.class);
        ChangeEvent changeEvent = null;
        for (CellEditorListener l : listeners) {
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            l.editingCanceled(changeEvent);
        }
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCancelled();
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.cellEditorListeners.add(CellEditorListener.class, l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.cellEditorListeners.remove(CellEditorListener.class, l);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.setMetaData((ColumnMetaData)value);
        return this;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setMetaData((ColumnMetaData)value);
        return this;
    }

    private void setMetaData(ColumnMetaData value) {
        this.value = value;
        this.valueTypeBox.setSelectedIndex(value.getAttributeValueType());
        this.selectCheckBox.setSelected(value.isSelected());
        this.nameField.setText(value.getUserDefinedAttributeName());
        this.roleBox.setSelectedItem(value.getRole());
    }
}

