/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.nio;

import com.rapidminer.datatable.DataTableExampleSetAdapter;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.tools.CellColorProviderAlternating;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.wizards.AbstractWizard;
import com.rapidminer.gui.tools.dialogs.wizards.WizardStep;
import com.rapidminer.gui.tools.table.EditableTableHeader;
import com.rapidminer.gui.tools.table.EditableTableHeaderColumn;
import com.rapidminer.gui.viewer.DataTableViewerTableModel;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.nio.ErrorTableModel;
import com.rapidminer.operator.nio.ImportWizardUtils;
import com.rapidminer.operator.nio.MetaDataTableHeaderCellEditor;
import com.rapidminer.operator.nio.RowFilteringTableModel;
import com.rapidminer.operator.nio.model.DataResultSet;
import com.rapidminer.operator.nio.model.ParsingError;
import com.rapidminer.operator.nio.model.WizardState;
import com.rapidminer.parameter.ParameterTypeDateFormat;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class MetaDataDeclarationWizardStep
extends WizardStep {
    private Action reloadAction = new ResourceAction("wizard.validate_value_types", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            MetaDataDeclarationWizardStep.this.toggleReload();
        }
    };
    private Action cancelReloadAction = new ResourceAction("wizard.abort_validate_value_types", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            MetaDataDeclarationWizardStep.this.toggleReload();
        }
    };
    private ReconfigurableButton reloadButton = new ReconfigurableButton(this.reloadAction);
    private Action guessValueTypes = new ResourceAction("wizard.guess_value_types", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            MetaDataDeclarationWizardStep.this.toggleGuessValueTypes();
        }
    };
    private Action cancelGuessValueTypes = new ResourceAction("wizard.abort_guess_value_types", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            MetaDataDeclarationWizardStep.this.toggleGuessValueTypes();
        }
    };
    private ReconfigurableButton guessButton = new ReconfigurableButton(this.guessValueTypes);
    private JCheckBox errorsAsMissingBox = new JCheckBox(new ResourceAction("wizard.error_tolerant", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            MetaDataDeclarationWizardStep.this.state.getTranslationConfiguration().setFaultTolerant(MetaDataDeclarationWizardStep.this.errorsAsMissingBox.isSelected());
        }
    });
    private JCheckBox filterErrorsBox = new JCheckBox(new ResourceAction("wizard.show_error_rows", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MetaDataDeclarationWizardStep.this.filteredModel != null) {
                MetaDataDeclarationWizardStep.this.filteredModel.setFilterEnabled(MetaDataDeclarationWizardStep.this.filterErrorsBox.isSelected());
            }
        }
    });
    private JComboBox dateFormatField = new JComboBox<String>(ParameterTypeDateFormat.PREDEFINED_DATE_FORMATS);
    private JCheckBox limitedPreviewBox = new JCheckBox(I18N.getMessage(I18N.getGUIBundle(), "gui.action.importwizard.limited_preview.label", ImportWizardUtils.getPreviewLength()));
    private WizardState state;
    private JPanel panel = new JPanel(new BorderLayout());
    private JScrollPane tableScrollPane;
    private ErrorTableModel errorTableModel = new ErrorTableModel();
    private RowFilteringTableModel filteredModel;
    private JLabel errorLabel = new JLabel();
    private boolean isGuessing = false;
    private boolean isReloading = false;
    private ExtendedJTable previewTable;

    public MetaDataDeclarationWizardStep(WizardState state) {
        super("importwizard.metadata");
        this.limitedPreviewBox.setSelected(true);
        this.state = state;
        this.dateFormatField.setEditable(true);
        this.dateFormatField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetaDataDeclarationWizardStep.this.state.getTranslationConfiguration().setDatePattern((String)MetaDataDeclarationWizardStep.this.dateFormatField.getSelectedItem());
            }
        });
        JPanel buttonPanel = new JPanel(new FlowLayout(0));
        buttonPanel.add(this.reloadButton);
        buttonPanel.add(this.guessButton);
        buttonPanel.add(this.limitedPreviewBox);
        ResourceLabel label = new ResourceLabel("date_format", new Object[0]);
        label.setLabelFor(this.dateFormatField);
        buttonPanel.add(label);
        buttonPanel.add(this.dateFormatField);
        this.panel.add((Component)buttonPanel, "North");
        JPanel errorPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 23;
        c.ipady = 4;
        c.ipadx = 4;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        errorPanel.add((Component)this.errorLabel, c);
        c.weightx = 0.0;
        c.gridwidth = -1;
        errorPanel.add((Component)this.errorsAsMissingBox, c);
        c.weightx = 0.0;
        c.gridwidth = 0;
        errorPanel.add((Component)this.filterErrorsBox, c);
        final JTable errorTable = new JTable(this.errorTableModel);
        errorTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selected;
                if (!e.getValueIsAdjusting() && (selected = errorTable.getSelectedRow()) >= 0) {
                    ParsingError error = MetaDataDeclarationWizardStep.this.errorTableModel.getErrorInRow(selected);
                    int row = error.getExampleIndex();
                    row = MetaDataDeclarationWizardStep.this.filteredModel.inverseTranslateRow(row);
                    if (row == -1) {
                        return;
                    }
                    int col = error.getColumn();
                    MetaDataDeclarationWizardStep.this.previewTable.setRowSelectionInterval(row, row);
                    MetaDataDeclarationWizardStep.this.previewTable.setColumnSelectionInterval(col, col);
                }
            }
        });
        JScrollPane errorScrollPane = new JScrollPane(errorTable);
        errorScrollPane.setPreferredSize(new Dimension(500, 80));
        c.weighty = 1.0;
        c.gridwidth = 0;
        errorPanel.add((Component)errorScrollPane, c);
        this.panel.add((Component)errorPanel, "South");
        JLabel dummy = new JLabel("-");
        dummy.setPreferredSize(new Dimension(500, 500));
        dummy.setMinimumSize(new Dimension(500, 500));
        this.tableScrollPane = new JScrollPane(dummy, 22, 32);
        this.panel.add((Component)this.tableScrollPane, "Center");
    }

    @Override
    protected boolean performEnteringAction(AbstractWizard.WizardStepDirection direction) {
        this.dateFormatField.setSelectedItem(this.state.getTranslationConfiguration().getDatePattern());
        this.errorsAsMissingBox.setSelected(this.state.getTranslationConfiguration().isFaultTolerant());
        new ProgressThread("loading_data"){

            @Override
            public void run() {
                try {
                    DataResultSet previewResultSet = MetaDataDeclarationWizardStep.this.state.getDataResultSetFactory().makeDataResultSet(MetaDataDeclarationWizardStep.this.state.getOperator());
                    MetaDataDeclarationWizardStep.this.state.getTranslationConfiguration().reconfigure(previewResultSet);
                }
                catch (OperatorException e1) {
                    ImportWizardUtils.showErrorMessage(MetaDataDeclarationWizardStep.this.state.getDataResultSetFactory().getResourceName(), e1.toString(), e1);
                    return;
                }
                try {
                    TableModel dataPreview = MetaDataDeclarationWizardStep.this.state.getDataResultSetFactory().makePreviewTableModel(this.getProgressListener());
                    int nameIndex = MetaDataDeclarationWizardStep.this.state.getTranslationConfiguration().getNameRow();
                    if (nameIndex != -1) {
                        for (int i = 0; i < dataPreview.getColumnCount(); ++i) {
                            MetaDataDeclarationWizardStep.this.state.getTranslationConfiguration().getColumnMetaData(i).setUserDefinedAttributeName((String)dataPreview.getValueAt(nameIndex, i));
                        }
                    }
                }
                catch (Exception e) {
                    ImportWizardUtils.showErrorMessage(MetaDataDeclarationWizardStep.this.state.getDataResultSetFactory().getResourceName(), e.toString(), e);
                    return;
                }
                MetaDataDeclarationWizardStep.this.guessValueTypes();
            }
        }.start();
        return true;
    }

    private void updateErrors() {
        int size = this.state.getTranslator().getErrors().size();
        this.errorLabel.setText(size + " errors.");
        if (size == 0) {
            this.errorLabel.setIcon(SwingTools.createIcon("16/ok.png"));
        } else {
            this.errorLabel.setIcon(SwingTools.createIcon("16/error.png"));
        }
        this.errorTableModel.setErrors(this.state.getTranslator().getErrors());
    }

    private void updateTableModel(ExampleSet exampleSet) {
        if (this.previewTable == null) {
            this.previewTable = new ExtendedJTable(false, false, false);
        }
        DataTableViewerTableModel model = new DataTableViewerTableModel(new DataTableExampleSetAdapter(exampleSet, null));
        LinkedList<Integer> rowsList = new LinkedList<Integer>();
        int lastHit = -1;
        for (ParsingError error : this.state.getTranslator().getErrors()) {
            if (error.getExampleIndex() == lastHit) continue;
            rowsList.add(error.getExampleIndex());
            lastHit = error.getExampleIndex();
        }
        int[] rowMap = new int[rowsList.size()];
        int j = 0;
        for (Integer row : rowsList) {
            rowMap[j++] = row;
        }
        this.filteredModel = new RowFilteringTableModel(model, rowMap, this.filterErrorsBox.isSelected());
        this.previewTable.setModel(this.filteredModel);
        TableColumnModel columnModel = this.previewTable.getColumnModel();
        this.previewTable.setTableHeader(new EditableTableHeader(columnModel));
        MetaDataTableHeaderCellEditor headerEditor = new MetaDataTableHeaderCellEditor();
        MetaDataTableHeaderCellEditor headerRenderer = new MetaDataTableHeaderCellEditor();
        for (int i = 0; i < this.previewTable.getColumnCount(); ++i) {
            EditableTableHeaderColumn col = (EditableTableHeaderColumn)this.previewTable.getColumnModel().getColumn(i);
            col.setHeaderValue(this.state.getTranslationConfiguration().getColumnMetaData()[i]);
            col.setHeaderRenderer(headerRenderer);
            col.setHeaderEditor(headerEditor);
        }
        this.previewTable.getTableHeader().setReorderingAllowed(false);
        this.previewTable.setCellColorProvider(new CellColorProviderAlternating(){

            @Override
            public Color getCellColor(int row, int column) {
                row = MetaDataDeclarationWizardStep.this.filteredModel.translateRow(row);
                ParsingError error = MetaDataDeclarationWizardStep.this.state.getTranslator().getErrorByExampleIndexAndColumn(row, column);
                if (error != null) {
                    return SwingTools.DARK_YELLOW;
                }
                return super.getCellColor(row, column);
            }
        });
        this.tableScrollPane.setViewportView(this.previewTable);
    }

    @Override
    protected boolean performLeavingAction(AbstractWizard.WizardStepDirection direction) {
        if (direction == AbstractWizard.WizardStepDirection.FINISH) {
            try {
                if (this.state.getTranslator() != null) {
                    this.state.getTranslator().close();
                }
            }
            catch (OperatorException e) {
                ImportWizardUtils.showErrorMessage(this.state.getDataResultSetFactory().getResourceName(), e.toString(), e);
            }
        }
        return true;
    }

    @Override
    protected boolean canGoBack() {
        return true;
    }

    @Override
    protected boolean canProceed() {
        return true;
    }

    @Override
    protected JComponent getComponent() {
        return this.panel;
    }

    private void reload() {
        this.reloadButton.configurePropertiesFromAction(this.cancelReloadAction);
        new ProgressThread("loading_data"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                block14: {
                    DataResultSet resultSet;
                    block12: {
                        resultSet = null;
                        if (MetaDataDeclarationWizardStep.this.state.getTranslator() != null) {
                            MetaDataDeclarationWizardStep.this.state.getTranslator().close();
                        }
                        resultSet = MetaDataDeclarationWizardStep.this.state.getDataResultSetFactory().makeDataResultSet(null);
                        MetaDataDeclarationWizardStep.this.state.getTranslator().clearErrors();
                        final ExampleSet exampleSet = MetaDataDeclarationWizardStep.this.state.readNow(resultSet, MetaDataDeclarationWizardStep.this.limitedPreviewBox.isSelected(), this.getProgressListener());
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MetaDataDeclarationWizardStep.this.updateTableModel(exampleSet);
                                MetaDataDeclarationWizardStep.this.updateErrors();
                            }
                        });
                        if (resultSet == null) break block12;
                        try {
                            resultSet.close();
                        }
                        catch (OperatorException e) {
                            LogService.getRoot().log(Level.WARNING, "Failed to close result set: " + e, e);
                        }
                    }
                    this.getProgressListener().complete();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MetaDataDeclarationWizardStep.this.reloadButton.configurePropertiesFromAction(MetaDataDeclarationWizardStep.this.reloadAction);
                            MetaDataDeclarationWizardStep.this.reloadButton.setEnabled(true);
                            MetaDataDeclarationWizardStep.this.isReloading = false;
                        }
                    });
                    break block14;
                    catch (OperatorException e) {
                        block13: {
                            try {
                                ImportWizardUtils.showErrorMessage(MetaDataDeclarationWizardStep.this.state.getDataResultSetFactory().getResourceName(), e.toString(), e);
                                if (resultSet == null) break block13;
                            }
                            catch (Throwable throwable) {
                                if (resultSet != null) {
                                    try {
                                        resultSet.close();
                                    }
                                    catch (OperatorException e2) {
                                        LogService.getRoot().log(Level.WARNING, "Failed to close result set: " + e2, e2);
                                    }
                                }
                                this.getProgressListener().complete();
                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                throw throwable;
                            }
                            try {
                                resultSet.close();
                            }
                            catch (OperatorException e3) {
                                LogService.getRoot().log(Level.WARNING, "Failed to close result set: " + e3, e3);
                            }
                        }
                        this.getProgressListener().complete();
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                }
            }
        }.start();
    }

    private void cancelReload() {
        this.state.getTranslator().cancelLoading();
        this.reloadButton.setEnabled(false);
    }

    private void guessValueTypes() {
        this.guessButton.configurePropertiesFromAction(this.cancelGuessValueTypes);
        this.isGuessing = true;
        new ProgressThread("guessing_value_types"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                block15: {
                    DataResultSet resultSet;
                    block13: {
                        Thread.yield();
                        resultSet = null;
                        if (MetaDataDeclarationWizardStep.this.state.getTranslator() != null) {
                            MetaDataDeclarationWizardStep.this.state.getTranslator().close();
                        }
                        resultSet = MetaDataDeclarationWizardStep.this.state.getDataResultSetFactory().makeDataResultSet(null);
                        MetaDataDeclarationWizardStep.this.state.getTranslator().clearErrors();
                        MetaDataDeclarationWizardStep.this.state.getTranslationConfiguration().resetValueTypes();
                        MetaDataDeclarationWizardStep.this.state.getTranslator().guessValueTypes(MetaDataDeclarationWizardStep.this.state.getTranslationConfiguration(), resultSet, MetaDataDeclarationWizardStep.this.state.getNumberOfPreviewRows(), this.getProgressListener());
                        if (!MetaDataDeclarationWizardStep.this.state.getTranslator().isGuessingCancelled()) {
                            final ExampleSet exampleSet = MetaDataDeclarationWizardStep.this.state.readNow(resultSet, MetaDataDeclarationWizardStep.this.limitedPreviewBox.isSelected(), this.getProgressListener());
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    MetaDataDeclarationWizardStep.this.updateTableModel(exampleSet);
                                    MetaDataDeclarationWizardStep.this.updateErrors();
                                }
                            });
                        }
                        if (resultSet == null) break block13;
                        try {
                            resultSet.close();
                        }
                        catch (OperatorException e) {
                            LogService.getRoot().log(Level.WARNING, "Failed to close result set: " + e, e);
                        }
                    }
                    this.getProgressListener().complete();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MetaDataDeclarationWizardStep.this.guessButton.configurePropertiesFromAction(MetaDataDeclarationWizardStep.this.guessValueTypes);
                            MetaDataDeclarationWizardStep.this.guessButton.setEnabled(true);
                            MetaDataDeclarationWizardStep.this.isGuessing = false;
                        }
                    });
                    break block15;
                    catch (OperatorException e) {
                        block14: {
                            try {
                                ImportWizardUtils.showErrorMessage(MetaDataDeclarationWizardStep.this.state.getDataResultSetFactory().getResourceName(), e.toString(), e);
                                if (resultSet == null) break block14;
                            }
                            catch (Throwable throwable) {
                                if (resultSet != null) {
                                    try {
                                        resultSet.close();
                                    }
                                    catch (OperatorException e2) {
                                        LogService.getRoot().log(Level.WARNING, "Failed to close result set: " + e2, e2);
                                    }
                                }
                                this.getProgressListener().complete();
                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                throw throwable;
                            }
                            try {
                                resultSet.close();
                            }
                            catch (OperatorException e3) {
                                LogService.getRoot().log(Level.WARNING, "Failed to close result set: " + e3, e3);
                            }
                        }
                        this.getProgressListener().complete();
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                }
            }
        }.start();
    }

    private void cancelGuessing() {
        this.state.getTranslator().cancelGuessing();
        this.state.getTranslator().cancelLoading();
        this.guessButton.setEnabled(false);
    }

    private void toggleGuessValueTypes() {
        boolean bl = this.isGuessing = !this.isGuessing;
        if (this.isGuessing) {
            this.guessValueTypes();
        } else {
            this.cancelGuessing();
        }
    }

    private void toggleReload() {
        boolean bl = this.isReloading = !this.isReloading;
        if (this.isReloading) {
            this.reload();
        } else {
            this.cancelReload();
        }
    }

    private class ReconfigurableButton
    extends JButton {
        private static final long serialVersionUID = 1L;

        private ReconfigurableButton(Action action) {
            super(action);
        }

        @Override
        protected void configurePropertiesFromAction(Action a) {
            super.configurePropertiesFromAction(a);
        }
    }
}

