/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.nio;

import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJTabbedPane;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.dialogs.wizards.WizardStep;
import com.rapidminer.operator.nio.ExcelSheetTableModel;
import com.rapidminer.operator.nio.ImportWizardUtils;
import com.rapidminer.operator.nio.model.ExcelResultSetConfiguration;
import java.awt.BorderLayout;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import jxl.Workbook;
import jxl.read.biff.BiffException;

public class ExcelWorkbookPane
extends JPanel {
    private static final long serialVersionUID = 9179757216097316344L;
    private ExcelResultSetConfiguration configuration;
    private ExtendedJTabbedPane sheetsPane;
    private ExtendedJTable[] tables;

    public ExcelWorkbookPane(WizardStep wizardStep, ExcelResultSetConfiguration configuration) {
        this.configuration = configuration;
        this.sheetsPane = new ExtendedJTabbedPane();
        this.sheetsPane.setBorder(null);
        this.setLayout(new BorderLayout());
        this.add(this.sheetsPane);
    }

    public void loadWorkbook() {
        if (this.configuration.hasWorkbook()) {
            return;
        }
        this.sheetsPane.removeAll();
        JPanel dummy = new JPanel();
        dummy.add(new ResourceLabel("loading_excel_sheets", new Object[0]));
        this.sheetsPane.addTab("Pending...", dummy);
        new ProgressThread("load_workbook", false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.getProgressListener().setTotal(100);
                this.getProgressListener().setCompleted(10);
                try {
                    final Workbook finalWorkbook = ExcelWorkbookPane.this.configuration.getWorkbook();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ExcelWorkbookPane.access$102(ExcelWorkbookPane.this, new ExtendedJTable[finalWorkbook.getNumberOfSheets()]);
                            String[] sheetNames = finalWorkbook.getSheetNames();
                            for (int sheetIndex = 0; sheetIndex < finalWorkbook.getNumberOfSheets(); ++sheetIndex) {
                                ExcelSheetTableModel sheetModel = new ExcelSheetTableModel(finalWorkbook.getSheet(sheetIndex));
                                ((ExcelWorkbookPane)ExcelWorkbookPane.this).tables[sheetIndex] = new ExtendedJTable((TableModel)sheetModel, false, false);
                                ExcelWorkbookPane.this.tables[sheetIndex].setAutoResizeMode(0);
                                ExcelWorkbookPane.this.tables[sheetIndex].setBorder(null);
                                ExcelWorkbookPane.this.tables[sheetIndex].setRowSelectionAllowed(false);
                                ExcelWorkbookPane.this.tables[sheetIndex].setColumnSelectionAllowed(false);
                                ExcelWorkbookPane.this.tables[sheetIndex].setCellSelectionEnabled(true);
                                ExtendedJScrollPane pane = new ExtendedJScrollPane(ExcelWorkbookPane.this.tables[sheetIndex]);
                                pane.setBorder(null);
                                if (sheetIndex == 0) {
                                    ExcelWorkbookPane.this.sheetsPane.removeAll();
                                }
                                ExcelWorkbookPane.this.sheetsPane.addTab(sheetNames[sheetIndex], pane);
                            }
                            ExcelWorkbookSelection selection = new ExcelWorkbookSelection(ExcelWorkbookPane.this.configuration.getSheet(), ExcelWorkbookPane.this.configuration.getColumnOffset(), ExcelWorkbookPane.this.configuration.getRowOffset(), ExcelWorkbookPane.this.configuration.getColumnLast(), ExcelWorkbookPane.this.configuration.getRowLast());
                            ExcelWorkbookPane.this.setSelection(selection);
                        }
                    });
                }
                catch (BiffException e) {
                    ImportWizardUtils.showErrorMessage(ExcelWorkbookPane.this.configuration.getResourceName(), e.toString(), e);
                }
                catch (IOException e) {
                    ImportWizardUtils.showErrorMessage(ExcelWorkbookPane.this.configuration.getResourceName(), e.toString(), e);
                }
                finally {
                    this.getProgressListener().complete();
                }
            }
        }.start();
    }

    public void setSelection(ExcelWorkbookSelection selection) {
        int sheetIndex = selection.getSheetIndex();
        if (sheetIndex < this.sheetsPane.getTabCount()) {
            this.sheetsPane.setSelectedIndex(sheetIndex);
            this.tables[sheetIndex].clearSelection();
            this.tables[sheetIndex].setColumnSelectionInterval(Math.max(selection.getColumnIndexStart(), 0), Math.min(selection.getColumnIndexEnd(), this.tables[sheetIndex].getColumnCount() - 1));
            this.tables[sheetIndex].setRowSelectionInterval(Math.max(selection.getRowIndexStart(), 0), Math.min(selection.getRowIndexEnd(), this.tables[sheetIndex].getRowCount() - 1));
        }
    }

    public ExcelWorkbookSelection getSelection() {
        int sheetIndex = this.sheetsPane.getSelectedIndex();
        int columnIndexStart = this.tables[sheetIndex].getSelectedColumn();
        int rowIndexStart = this.tables[sheetIndex].getSelectedRow();
        int columnIndexEnd = columnIndexStart + this.tables[sheetIndex].getSelectedColumnCount() - 1;
        int rowIndexEnd = rowIndexStart + this.tables[sheetIndex].getSelectedRowCount() - 1;
        if (columnIndexStart == -1) {
            return new ExcelWorkbookSelection(sheetIndex, 0, 0, this.tables[sheetIndex].getColumnCount() - 1, this.tables[sheetIndex].getRowCount() - 1);
        }
        return new ExcelWorkbookSelection(sheetIndex, columnIndexStart, rowIndexStart, columnIndexEnd, rowIndexEnd);
    }

    static /* synthetic */ ExtendedJTable[] access$102(ExcelWorkbookPane x0, ExtendedJTable[] x1) {
        x0.tables = x1;
        return x1;
    }

    public static class ExcelWorkbookSelection {
        private int sheetIndex;
        private int columnIndexStart;
        private int rowIndexStart;
        private int columnIndexEnd;
        private int rowIndexEnd;

        public ExcelWorkbookSelection(int sheetIndex, int columnIndexStart, int rowIndexStart, int columnIndexEnd, int rowIndexEnd) {
            this.sheetIndex = sheetIndex;
            this.columnIndexStart = columnIndexStart;
            this.rowIndexStart = rowIndexStart;
            this.columnIndexEnd = columnIndexEnd;
            this.rowIndexEnd = rowIndexEnd;
        }

        public String toString() {
            return this.sheetIndex + ": " + this.columnIndexStart + ":" + this.rowIndexStart + " - " + this.columnIndexEnd + ":" + this.rowIndexEnd;
        }

        public int getSheetIndex() {
            return this.sheetIndex;
        }

        public int getColumnIndexEnd() {
            return this.columnIndexEnd;
        }

        public int getColumnIndexStart() {
            return this.columnIndexStart;
        }

        public int getRowIndexEnd() {
            return this.rowIndexEnd;
        }

        public int getRowIndexStart() {
            return this.rowIndexStart;
        }

        public int getSelectionWidth() {
            return this.columnIndexEnd - this.columnIndexStart + 1;
        }

        public int getSelectionHeight() {
            return this.rowIndexEnd - this.rowIndexStart + 1;
        }
    }
}

