/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.nio;

import com.rapidminer.gui.tools.dialogs.wizards.dataimport.excel.ExcelWorkbookPane;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import jxl.Sheet;

public class ExcelTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -2650777734917514059L;
    private Sheet excelSheet;
    private ExcelWorkbookPane.ExcelWorkbookSelection reductionSelection;
    private List<String> columnNames;
    private final Map<Integer, String> annotationTypes = new HashMap<Integer, String>();

    public ExcelTableModel(Sheet sheet) {
        this.excelSheet = sheet;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public int getColumnCount() {
        if (this.reductionSelection == null) {
            return this.excelSheet.getColumns() + 1;
        }
        return this.reductionSelection.getColumnIndexEnd() - this.reductionSelection.getColumnIndexStart() + 1 + 1;
    }

    @Override
    public int getRowCount() {
        if (this.reductionSelection == null) {
            return this.excelSheet.getRows();
        }
        return this.reductionSelection.getRowIndexEnd() - this.reductionSelection.getRowIndexStart() + 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            String value = this.getAnnotationMap().get(rowIndex);
            if (value == null) {
                return "-";
            }
            return value;
        }
        --columnIndex;
        if (this.reductionSelection == null) {
            return this.excelSheet.getCell(columnIndex, rowIndex).getContents();
        }
        return this.excelSheet.getCell(columnIndex + this.reductionSelection.getColumnIndexStart(), rowIndex + this.reductionSelection.getRowIndexStart()).getContents();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            if ("-".equals(aValue)) {
                this.getAnnotationMap().remove(rowIndex);
            } else {
                this.getAnnotationMap().put(rowIndex, (String)aValue);
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "Use as";
        }
        --column;
        if (this.columnNames == null) {
            if (this.reductionSelection != null) {
                column += this.reductionSelection.getColumnIndexStart();
            }
            StringBuffer buffer = new StringBuffer();
            int currentNumber = column % 26;
            buffer.append((char)(currentNumber + 65));
            column -= currentNumber;
            while (column > 0) {
                currentNumber = (column /= 26) % 26;
                buffer.append((char)(currentNumber + 65));
                column -= currentNumber;
            }
            return buffer.toString();
        }
        return this.columnNames.get(column);
    }

    public void createView(ExcelWorkbookPane.ExcelWorkbookSelection selection) {
        this.reductionSelection = selection;
    }

    public void resetReduction() {
        this.reductionSelection = null;
    }

    public void setNames(List<String> names) {
        this.columnNames = names;
    }

    public void resetNames() {
        this.columnNames = null;
    }

    public Map<Integer, String> getAnnotationMap() {
        return this.annotationTypes;
    }
}

