/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.nio;

import com.rapidminer.operator.nio.model.ExcelResultSetConfiguration;
import com.rapidminer.tools.Tools;
import java.io.IOException;
import javax.swing.table.AbstractTableModel;
import jxl.Sheet;
import jxl.read.biff.BiffException;

public class ExcelSheetTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private Sheet sheet;
    private ExcelResultSetConfiguration config;

    public ExcelSheetTableModel(Sheet sheet) {
        this.sheet = sheet;
    }

    public ExcelSheetTableModel(ExcelResultSetConfiguration excelResultSetConfiguration) throws IndexOutOfBoundsException, BiffException, IOException {
        this.config = excelResultSetConfiguration;
        this.sheet = this.config.getWorkbook().getSheet(this.config.getSheet());
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.config != null) {
            return this.sheet.getCell(columnIndex + this.config.getColumnOffset(), rowIndex + this.config.getRowOffset()).getContents();
        }
        return this.sheet.getCell(columnIndex, rowIndex).getContents();
    }

    @Override
    public int getRowCount() {
        if (this.config != null) {
            return this.config.getRowLast() - this.config.getRowOffset() + 1;
        }
        return this.sheet.getRows();
    }

    @Override
    public int getColumnCount() {
        if (this.config != null) {
            return this.config.getColumnLast() - this.config.getColumnOffset() + 1;
        }
        return this.sheet.getColumns();
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (this.config != null) {
            return Tools.getExcelColumnName(columnIndex + this.config.getColumnOffset());
        }
        return Tools.getExcelColumnName(columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }
}

