/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.nio;

import com.rapidminer.gui.tools.dialogs.wizards.AbstractWizard;
import com.rapidminer.gui.tools.dialogs.wizards.WizardStep;
import com.rapidminer.operator.nio.ExcelWorkbookPane;
import com.rapidminer.operator.nio.model.ExcelResultSetConfiguration;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

class ExcelSheetSelectionWizardStep
extends WizardStep {
    private ExcelResultSetConfiguration configuration;
    private final ExcelWorkbookPane workbookSelectionPanel;
    private final JLabel errorLabel = new JLabel("");

    public ExcelSheetSelectionWizardStep(ExcelResultSetConfiguration configuration) {
        super("importwizard.excel_data_selection");
        this.configuration = configuration;
        this.workbookSelectionPanel = new ExcelWorkbookPane(this, configuration);
    }

    @Override
    protected boolean canGoBack() {
        return true;
    }

    @Override
    protected boolean canProceed() {
        return true;
    }

    @Override
    protected boolean performEnteringAction(AbstractWizard.WizardStepDirection direction) {
        if (direction == AbstractWizard.WizardStepDirection.FORWARD) {
            this.workbookSelectionPanel.loadWorkbook();
        }
        return true;
    }

    @Override
    protected boolean performLeavingAction(AbstractWizard.WizardStepDirection direction) {
        if (direction == AbstractWizard.WizardStepDirection.FORWARD) {
            ExcelWorkbookPane.ExcelWorkbookSelection selection = this.workbookSelectionPanel.getSelection();
            this.configuration.setSheet(selection.getSheetIndex());
            this.configuration.setColumnOffset(selection.getColumnIndexStart());
            this.configuration.setColumnLast(selection.getColumnIndexEnd());
            this.configuration.setRowOffset(selection.getRowIndexStart());
            this.configuration.setRowLast(selection.getRowIndexEnd());
        } else {
            this.configuration.closeWorkbook();
        }
        return true;
    }

    @Override
    protected JComponent getComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.workbookSelectionPanel, "Center");
        panel.add((Component)this.errorLabel, "South");
        return panel;
    }
}

