/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.nio;

import com.rapidminer.gui.tools.dialogs.wizards.AbstractWizard;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.FileSelectionWizardStep;
import com.rapidminer.operator.nio.model.ExcelResultSetConfiguration;
import java.io.File;
import javax.swing.filechooser.FileFilter;

public class ExcelFileSelectionWizardStep
extends FileSelectionWizardStep {
    private ExcelResultSetConfiguration configuration;

    public ExcelFileSelectionWizardStep(AbstractWizard parent, ExcelResultSetConfiguration configuration) {
        super(parent, new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith("xls");
            }

            @Override
            public String getDescription() {
                return "Excel Files";
            }
        });
        this.configuration = configuration;
    }

    @Override
    protected boolean performEnteringAction(AbstractWizard.WizardStepDirection direction) {
        if (this.configuration.getFile() != null) {
            this.fileChooser.setSelectedFile(this.configuration.getFile());
        }
        return true;
    }

    @Override
    protected boolean performLeavingAction(AbstractWizard.WizardStepDirection direction) {
        this.configuration.setWorkbookFile(this.getSelectedFile());
        return true;
    }
}

