/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.nio;

import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.OperatorVersion;
import com.rapidminer.operator.io.AbstractReader;
import com.rapidminer.operator.nio.ExcelExampleSourceConfigurationWizardCreator;
import com.rapidminer.operator.nio.model.AbstractDataResultSetReader;
import com.rapidminer.operator.nio.model.DataResultSetFactory;
import com.rapidminer.operator.nio.model.ExcelResultSetConfiguration;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeConfiguration;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.List;

public class ExcelExampleSource
extends AbstractDataResultSetReader {
    public static final OperatorVersion CHANGE_5_0_11_NAME_SCHEMA = new OperatorVersion(5, 0, 11);
    public static final String PARAMETER_EXCEL_FILE = "excel_file";
    public static final String PARAMETER_SHEET_NUMBER = "sheet_number";
    public static final String PARAMETER_LABEL_COLUMN = "label_column";
    public static final String PARAMETER_ID_COLUMN = "id_column";
    public static final String PARAMETER_CREATE_LABEL = "create_label";
    public static final String PARAMETER_CREATE_ID = "create_id";
    public static final String PARAMETER_IMPORTED_CELL_RANGE = "imported_cell_range";

    public ExcelExampleSource(OperatorDescription description) {
        super(description);
    }

    @Override
    protected DataResultSetFactory getDataResultSetFactory() throws OperatorException {
        return new ExcelResultSetConfiguration(this);
    }

    @Override
    protected NumberFormat getNumberFormat() throws OperatorException {
        return null;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterTypeConfiguration type = new ParameterTypeConfiguration(ExcelExampleSourceConfigurationWizardCreator.class, this);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeFile(PARAMETER_EXCEL_FILE, "Name of the excel file to read the data from.", "xls", false));
        types.add(new ParameterTypeInt(PARAMETER_SHEET_NUMBER, "The number of the sheet which should be imported.", 1, Integer.MAX_VALUE, 1, false));
        types.add(new ParameterTypeString(PARAMETER_IMPORTED_CELL_RANGE, "Cells to import, in Excel notation, e.g. B2:D25 or B2 for an open interval.", false));
        types.addAll(super.getParameterTypes());
        return types;
    }

    @Override
    public OperatorVersion[] getIncompatibleVersionChanges() {
        return new OperatorVersion[]{new OperatorVersion(5, 0, 4), CHANGE_5_0_11_NAME_SCHEMA};
    }

    static {
        AbstractReader.registerReaderDescription(new AbstractReader.ReaderDescription("xls", ExcelExampleSource.class, PARAMETER_EXCEL_FILE));
    }
}

