/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.nio;

import com.rapidminer.gui.tools.CharTextField;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.UpdateQueue;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.gui.tools.dialogs.wizards.AbstractWizard;
import com.rapidminer.gui.tools.dialogs.wizards.WizardStep;
import com.rapidminer.operator.nio.CSVImportWizard;
import com.rapidminer.operator.nio.ErrorTableModel;
import com.rapidminer.operator.nio.ImportWizardUtils;
import com.rapidminer.operator.nio.model.CSVResultSetConfiguration;
import com.rapidminer.tools.io.Encoding;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.table.TableModel;

public class CSVSyntaxConfigurationWizardStep
extends WizardStep {
    private JPanel panel;
    private final JCheckBox trimLinesBox = new JCheckBox("Trim Lines", true);
    private final JComboBox encodingComboBox = new JComboBox<String>(Encoding.CHARSETS);
    private final JCheckBox skipCommentsBox = new JCheckBox("Skip Comments", true);
    private final JCheckBox useQuotesBox = new JCheckBox("Use Quotes", true);
    private final JTextField commentCharacterTextField = new JTextField("#");
    private final CharTextField quoteCharacterTextField = new CharTextField('\"');
    private final JLabel escapeCharacterLabel = new JLabel("Escape Character for Seperator:");
    private final CharTextField escapeCharacterTextField = new CharTextField('\\');
    private final JRadioButton commaButton = new JRadioButton("Comma \",\" ");
    private final JRadioButton semicolonButton = new JRadioButton("Semicolon \";\"");
    private final JRadioButton tabButton = new JRadioButton("Tab");
    private final JRadioButton spaceButton = new JRadioButton("Space");
    private final JRadioButton regexButton = new JRadioButton("Regular Expression");
    private final JTextField regexTextField = new JTextField(",\\s*|;\\s*");
    private CSVResultSetConfiguration configuration;
    private JTable previewTable;
    private JScrollPane tablePane;
    private ErrorTableModel errorTableModel = new ErrorTableModel();
    private JTable errorTable = new JTable(this.errorTableModel);
    private static UpdateQueue updateQueue;

    public CSVSyntaxConfigurationWizardStep(CSVImportWizard csvImportWizard, CSVResultSetConfiguration csvConfiguration) {
        super("specify_csv_parsing_options");
        this.configuration = csvConfiguration;
        this.skipCommentsBox.setSelected(this.configuration.isSkipComments());
        this.useQuotesBox.setSelected(this.configuration.isUseQuotes());
        this.trimLinesBox.setSelected(this.configuration.isTrimLines());
        this.commentCharacterTextField.setText(this.configuration.getCommentCharacters());
        this.escapeCharacterTextField.setText(String.valueOf(this.configuration.getEscapeCharacter()));
        this.quoteCharacterTextField.setText(String.valueOf(this.configuration.getQuoteCharacter()));
        this.encodingComboBox.setSelectedItem(this.configuration.getEncoding().name());
        String sep = this.configuration.getColumnSeparators();
        this.regexButton.setSelected(true);
        if (sep.equals(",")) {
            this.commaButton.setSelected(true);
        }
        if (sep.equals(";")) {
            this.semicolonButton.setSelected(true);
        }
        if (sep.equals("\t")) {
            this.tabButton.setSelected(true);
        }
        if (sep.equals("\\s")) {
            this.spaceButton.setSelected(true);
        }
        this.registerListeners();
        this.makePanel();
    }

    private void registerListeners() {
        this.encodingComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CSVSyntaxConfigurationWizardStep.this.configuration.setEncoding(Encoding.getEncoding(CSVSyntaxConfigurationWizardStep.this.encodingComboBox.getSelectedItem().toString()));
                CSVSyntaxConfigurationWizardStep.this.settingsChanged();
            }
        });
        this.trimLinesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CSVSyntaxConfigurationWizardStep.this.configuration.setTrimLines(CSVSyntaxConfigurationWizardStep.this.trimLinesBox.isSelected());
                CSVSyntaxConfigurationWizardStep.this.settingsChanged();
            }
        });
        this.skipCommentsBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CSVSyntaxConfigurationWizardStep.this.commentCharacterTextField.setEnabled(CSVSyntaxConfigurationWizardStep.this.skipCommentsBox.isSelected());
                CSVSyntaxConfigurationWizardStep.this.configuration.setSkipComments(CSVSyntaxConfigurationWizardStep.this.skipCommentsBox.isSelected());
                CSVSyntaxConfigurationWizardStep.this.settingsChanged();
            }
        });
        this.useQuotesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CSVSyntaxConfigurationWizardStep.this.quoteCharacterTextField.setEnabled(CSVSyntaxConfigurationWizardStep.this.useQuotesBox.isSelected());
                CSVSyntaxConfigurationWizardStep.this.escapeCharacterTextField.setEnabled(CSVSyntaxConfigurationWizardStep.this.useQuotesBox.isSelected());
                CSVSyntaxConfigurationWizardStep.this.configuration.setUseQuotes(CSVSyntaxConfigurationWizardStep.this.useQuotesBox.isSelected());
                CSVSyntaxConfigurationWizardStep.this.settingsChanged();
            }
        });
        this.quoteCharacterTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                CSVSyntaxConfigurationWizardStep.this.configuration.setQuoteCharacter(CSVSyntaxConfigurationWizardStep.this.quoteCharacterTextField.getText().charAt(0));
                CSVSyntaxConfigurationWizardStep.this.settingsChanged();
            }
        });
        this.escapeCharacterTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                CSVSyntaxConfigurationWizardStep.this.configuration.setEscapeCharacter(CSVSyntaxConfigurationWizardStep.this.escapeCharacterTextField.getText().charAt(0));
                CSVSyntaxConfigurationWizardStep.this.settingsChanged();
            }
        });
        this.commentCharacterTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                CSVSyntaxConfigurationWizardStep.this.configuration.setCommentCharacters(CSVSyntaxConfigurationWizardStep.this.commentCharacterTextField.getText());
                CSVSyntaxConfigurationWizardStep.this.settingsChanged();
            }
        });
        this.regexButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CSVSyntaxConfigurationWizardStep.this.regexTextField.setEnabled(CSVSyntaxConfigurationWizardStep.this.regexButton.isSelected());
                CSVSyntaxConfigurationWizardStep.this.configuration.setColumnSeparators(CSVSyntaxConfigurationWizardStep.this.getSplitExpression());
                CSVSyntaxConfigurationWizardStep.this.settingsChanged();
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.commaButton);
        buttonGroup.add(this.semicolonButton);
        buttonGroup.add(this.spaceButton);
        buttonGroup.add(this.tabButton);
        buttonGroup.add(this.regexButton);
        ActionListener separatorListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CSVSyntaxConfigurationWizardStep.this.configuration.setColumnSeparators(CSVSyntaxConfigurationWizardStep.this.getSplitExpression());
                CSVSyntaxConfigurationWizardStep.this.settingsChanged();
            }
        };
        this.commaButton.addActionListener(separatorListener);
        this.semicolonButton.addActionListener(separatorListener);
        this.spaceButton.addActionListener(separatorListener);
        this.tabButton.addActionListener(separatorListener);
        this.regexButton.addActionListener(separatorListener);
        this.regexTextField.addKeyListener(new KeyAdapter(){
            private Timer timer = new Timer(2000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    timer.stop();
                    CSVSyntaxConfigurationWizardStep.this.settingsChanged();
                }
            });

            @Override
            public void keyTyped(KeyEvent e) {
                this.timer.stop();
                this.timer.start();
            }
        });
    }

    private void makePanel() {
        JPanel optionPanel = new JPanel(ButtonDialog.createGridLayout(4, 1));
        JPanel tmpPanel = new JPanel(ButtonDialog.createGridLayout(1, 2));
        tmpPanel.add(new JLabel("File Encoding"));
        tmpPanel.add(this.encodingComboBox);
        optionPanel.add(tmpPanel);
        optionPanel.add(this.trimLinesBox);
        tmpPanel = new JPanel(ButtonDialog.createGridLayout(1, 2));
        tmpPanel.add(this.skipCommentsBox);
        tmpPanel.add(this.commentCharacterTextField);
        optionPanel.add(tmpPanel);
        optionPanel.setBorder(ButtonDialog.createTitledBorder("File Reading"));
        JPanel separationPanel = new JPanel(ButtonDialog.createGridLayout(5, 2));
        separationPanel.add(this.commaButton);
        separationPanel.add(this.spaceButton);
        separationPanel.add(this.semicolonButton);
        separationPanel.add(this.tabButton);
        separationPanel.add(this.regexButton);
        separationPanel.add(this.regexTextField);
        separationPanel.add(this.escapeCharacterLabel);
        separationPanel.add(this.escapeCharacterTextField);
        separationPanel.add(this.useQuotesBox);
        separationPanel.add(this.quoteCharacterTextField);
        separationPanel.setBorder(ButtonDialog.createTitledBorder("Column Separation"));
        JPanel parsingPanel = new JPanel(ButtonDialog.createGridLayout(1, 2));
        parsingPanel.add(optionPanel);
        parsingPanel.add(separationPanel);
        this.previewTable = new ExtendedJTable(false, false, false);
        this.tablePane = new JScrollPane(this.previewTable);
        this.tablePane.setVerticalScrollBarPolicy(22);
        this.tablePane.setHorizontalScrollBarPolicy(32);
        this.tablePane.setBorder(ButtonDialog.createBorder());
        this.panel = new JPanel(new BorderLayout(0, 6));
        this.panel.add((Component)parsingPanel, "North");
        this.panel.add((Component)this.tablePane, "Center");
        JScrollPane errorScrollPane = new JScrollPane(this.errorTable);
        errorScrollPane.setPreferredSize(new Dimension(500, 80));
        this.panel.add((Component)errorScrollPane, "South");
    }

    private String getSplitExpression() {
        String splitExpression = null;
        if (this.regexButton.isSelected()) {
            splitExpression = this.regexTextField.getText();
            if ("".equals(splitExpression)) {
                splitExpression = null;
            } else {
                try {
                    Pattern.compile(splitExpression);
                }
                catch (PatternSyntaxException pse) {
                    splitExpression = null;
                }
            }
        } else if (this.commaButton.isSelected()) {
            splitExpression = ",";
        } else if (this.semicolonButton.isSelected()) {
            splitExpression = ";";
        } else if (this.tabButton.isSelected()) {
            splitExpression = "\t";
        } else if (this.spaceButton.isSelected()) {
            splitExpression = "\\s";
        }
        return splitExpression;
    }

    private void settingsChanged() {
        updateQueue.executeBackgroundJob(new ProgressThread("loading_data"){

            @Override
            public void run() {
                try {
                    final TableModel model = CSVSyntaxConfigurationWizardStep.this.configuration.makePreviewTableModel(this.getProgressListener());
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            CSVSyntaxConfigurationWizardStep.this.previewTable.setModel(model);
                            CSVSyntaxConfigurationWizardStep.this.errorTableModel.setErrors(CSVSyntaxConfigurationWizardStep.this.configuration.getErrors());
                        }
                    });
                }
                catch (Exception e) {
                    CSVSyntaxConfigurationWizardStep.this.errorTableModel.setErrors(CSVSyntaxConfigurationWizardStep.this.configuration.getErrors());
                    ImportWizardUtils.showErrorMessage(CSVSyntaxConfigurationWizardStep.this.configuration.getResourceName(), e.toString(), e);
                }
            }
        });
    }

    @Override
    protected boolean performEnteringAction(AbstractWizard.WizardStepDirection direction) {
        updateQueue = new UpdateQueue("CSV-Preview-Fetcher");
        updateQueue.start();
        this.settingsChanged();
        return true;
    }

    @Override
    protected boolean performLeavingAction(AbstractWizard.WizardStepDirection direction) {
        if (updateQueue != null) {
            updateQueue.shutdown();
            updateQueue = null;
        }
        return super.performLeavingAction(direction);
    }

    @Override
    protected JComponent getComponent() {
        return this.panel;
    }

    @Override
    protected boolean canProceed() {
        return true;
    }

    @Override
    protected boolean canGoBack() {
        return true;
    }
}

