/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.nio;

import com.rapidminer.gui.tools.dialogs.wizards.AbstractWizard;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.FileSelectionWizardStep;
import com.rapidminer.operator.nio.model.CSVResultSetConfiguration;
import java.io.File;
import javax.swing.filechooser.FileFilter;

public class CSVFileSelectionWizardStep
extends FileSelectionWizardStep {
    private CSVResultSetConfiguration configuration;

    public CSVFileSelectionWizardStep(AbstractWizard parent, CSVResultSetConfiguration configuration) {
        super(parent, configuration.getCsvFileAsFile(), new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith("csv");
            }

            @Override
            public String getDescription() {
                return "Delimiter separated files";
            }
        });
        this.configuration = configuration;
    }

    @Override
    protected boolean performEnteringAction(AbstractWizard.WizardStepDirection direction) {
        if (this.configuration.getCsvFile() != null) {
            this.fileChooser.setSelectedFile(this.configuration.getCsvFileAsFile());
        }
        return true;
    }

    @Override
    protected boolean performLeavingAction(AbstractWizard.WizardStepDirection direction) {
        this.configuration.setCsvFile(this.getSelectedFile().getAbsolutePath());
        return true;
    }
}

