/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.nio;

import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class AnnotationTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private TableModel wrappedModel;
    private Map<Integer, String> annotationsMap;

    public AnnotationTableModel(TableModel wrappedModel, Map<Integer, String> annotationsMap) {
        this.annotationsMap = annotationsMap;
        this.wrappedModel = wrappedModel;
        wrappedModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                TableModelEvent translated = new TableModelEvent(AnnotationTableModel.this, e.getFirstRow(), e.getLastRow(), e.getColumn() + 1, e.getType());
                AnnotationTableModel.this.fireTableChanged(translated);
            }
        });
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "Annotation";
        }
        return this.wrappedModel.getColumnName(column - 1);
    }

    @Override
    public int getRowCount() {
        return this.wrappedModel.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.wrappedModel.getColumnCount() + 1;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            if ("-".equals(aValue)) {
                this.annotationsMap.remove(rowIndex);
            } else {
                this.annotationsMap.put(rowIndex, (String)aValue);
            }
        } else {
            this.wrappedModel.setValueAt(aValue, rowIndex, columnIndex - 1);
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            String annotation = this.annotationsMap.get(rowIndex);
            if (annotation == null) {
                annotation = "-";
            }
            return annotation;
        }
        return this.wrappedModel.getValueAt(rowIndex, columnIndex - 1);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }
}

