/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.nio;

import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.dialogs.wizards.AbstractWizard;
import com.rapidminer.gui.tools.dialogs.wizards.WizardStep;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.nio.AnnotationCellEditor;
import com.rapidminer.operator.nio.AnnotationTableModel;
import com.rapidminer.operator.nio.ImportWizardUtils;
import com.rapidminer.operator.nio.model.WizardState;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

public class AnnotationDeclarationWizardStep
extends WizardStep {
    private final JPanel panel = new JPanel(new BorderLayout());
    private final WizardState state;
    private JTable table;

    public AnnotationDeclarationWizardStep(WizardState state) {
        super("importwizard.annotations");
        this.state = state;
        this.table = new ExtendedJTable(false, false, false);
        this.panel.add((Component)new ExtendedJScrollPane(this.table), "Center");
    }

    @Override
    protected boolean performEnteringAction(AbstractWizard.WizardStepDirection direction) {
        if (direction == AbstractWizard.WizardStepDirection.FORWARD) {
            new ProgressThread("loading_data"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    this.getProgressListener().setTotal(100);
                    this.getProgressListener().setCompleted(10);
                    try {
                        final TableModel wrappedModel = AnnotationDeclarationWizardStep.this.state.getDataResultSetFactory().makePreviewTableModel(this.getProgressListener());
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                AnnotationDeclarationWizardStep.this.table.setModel(new AnnotationTableModel(wrappedModel, AnnotationDeclarationWizardStep.this.state.getTranslationConfiguration().getAnnotationsMap()));
                                AnnotationDeclarationWizardStep.this.table.getColumnModel().getColumn(0).setCellEditor(new AnnotationCellEditor());
                            }
                        });
                    }
                    catch (Exception e) {
                        ImportWizardUtils.showErrorMessage(AnnotationDeclarationWizardStep.this.state.getDataResultSetFactory().getResourceName(), e.toString(), e);
                    }
                    finally {
                        this.getProgressListener().complete();
                    }
                }
            }.start();
        }
        return true;
    }

    @Override
    protected boolean performLeavingAction(AbstractWizard.WizardStepDirection direction) {
        if ((direction == AbstractWizard.WizardStepDirection.BACKWARD || direction == AbstractWizard.WizardStepDirection.FINISH) && this.state.getTranslator() != null) {
            try {
                this.state.getTranslator().close();
            }
            catch (OperatorException e) {
                ImportWizardUtils.showErrorMessage(this.state.getDataResultSetFactory().getResourceName(), e.toString(), e);
            }
        }
        return true;
    }

    @Override
    protected boolean canGoBack() {
        return true;
    }

    @Override
    protected boolean canProceed() {
        return true;
    }

    @Override
    protected JComponent getComponent() {
        return this.panel;
    }
}

