/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.nio;

import com.rapidminer.gui.tools.dialogs.wizards.dataimport.DataImportWizard;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.nio.AnnotationDeclarationWizardStep;
import com.rapidminer.operator.nio.MetaDataDeclarationWizardStep;
import com.rapidminer.operator.nio.StoreDataWizardStep;
import com.rapidminer.operator.nio.model.AbstractDataResultSetReader;
import com.rapidminer.operator.nio.model.DataResultSetFactory;
import com.rapidminer.operator.nio.model.WizardState;
import com.rapidminer.repository.RepositoryLocation;

public abstract class AbstractDataImportWizard
extends DataImportWizard {
    private static final long serialVersionUID = 1L;
    private final WizardState state;
    private final AbstractDataResultSetReader reader;
    private RepositoryLocation preselectedLocation;

    public AbstractDataImportWizard(AbstractDataResultSetReader reader, RepositoryLocation preselectedLocation, String key, Object ... arguments) throws OperatorException {
        super(key, arguments);
        this.reader = reader;
        this.preselectedLocation = preselectedLocation;
        DataResultSetFactory factory = this.makeFactory(reader);
        this.state = new WizardState(reader, factory);
    }

    protected abstract DataResultSetFactory makeFactory(AbstractDataResultSetReader var1) throws OperatorException;

    protected void addCommonSteps() {
        this.addStep(new AnnotationDeclarationWizardStep(this.getState()));
        this.addStep(new MetaDataDeclarationWizardStep(this.getState()));
        if (this.getReader() == null) {
            this.addStep(new StoreDataWizardStep(this, this.getState(), this.preselectedLocation != null ? this.preselectedLocation.getAbsoluteLocation() : null));
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        this.getState().getDataResultSetFactory().close();
    }

    public WizardState getState() {
        return this.state;
    }

    public AbstractDataResultSetReader getReader() {
        return this.reader;
    }

    @Override
    public void finish() {
        super.finish();
        if (this.reader != null) {
            this.state.getTranslationConfiguration().setParameters(this.reader);
            this.state.getDataResultSetFactory().setParameters(this.reader);
            this.getState().getDataResultSetFactory().close();
        }
    }
}

