/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta.branch;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.meta.branch.AttributeAvailableCondition;
import com.rapidminer.operator.meta.branch.DataValueCondition;
import com.rapidminer.operator.meta.branch.ExpressionCondition;
import com.rapidminer.operator.meta.branch.FileExistsCondition;
import com.rapidminer.operator.meta.branch.InputExistsCondition;
import com.rapidminer.operator.meta.branch.MacroDefinedCondition;
import com.rapidminer.operator.meta.branch.MaxFitnessCondition;
import com.rapidminer.operator.meta.branch.MaxNumberOfAttributesCondition;
import com.rapidminer.operator.meta.branch.MaxNumberOfExamplesCondition;
import com.rapidminer.operator.meta.branch.MaxPerformanceValueCondition;
import com.rapidminer.operator.meta.branch.MinFitnessCondition;
import com.rapidminer.operator.meta.branch.MinNumberOfAttributesCondition;
import com.rapidminer.operator.meta.branch.MinNumberOfExamplesCondition;
import com.rapidminer.operator.meta.branch.MinPerformanceValueCondition;
import com.rapidminer.operator.meta.branch.ProcessBranchCondition;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPorts;
import com.rapidminer.operator.ports.MultiInputPortPairExtender;
import com.rapidminer.operator.ports.MultiOutputPortPairExtender;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.OutputPorts;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualStringCondition;
import com.rapidminer.parameter.conditions.NonEqualStringCondition;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.Tools;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ProcessBranch
extends OperatorChain {
    public static final String PARAMETER_CONDITION_TYPE = "condition_type";
    public static final String PARAMETER_CONDITION_VALUE = "condition_value";
    public static final String PARAMETER_RETURN_INNER_OUTPUT = "return_inner_output";
    public static final String PARAMETER_IO_OBJECT = "io_object";
    public static final String[] CONDITION_NAMES = new String[]{"attribute_value_filter", "attribute_available", "min_examples", "max_examples", "min_attributes", "max_attributes", "min_fitness", "max_fitness", "min_performance_value", "max_performance_value", "file_exists", "input_exists", "macro_defined", "expression"};
    public static final String CONDITION_INPUT_EXISTS = CONDITION_NAMES[11];
    public static final Class[] CONDITION_CLASSES = new Class[]{DataValueCondition.class, AttributeAvailableCondition.class, MinNumberOfExamplesCondition.class, MaxNumberOfExamplesCondition.class, MinNumberOfAttributesCondition.class, MaxNumberOfAttributesCondition.class, MinFitnessCondition.class, MaxFitnessCondition.class, MinPerformanceValueCondition.class, MaxPerformanceValueCondition.class, FileExistsCondition.class, InputExistsCondition.class, MacroDefinedCondition.class, ExpressionCondition.class};
    private String[] objectArray = null;
    private final InputPort conditionInput = (InputPort)this.getInputPorts().createPort("condition");
    private final OutputPort conditionInnerSourceThen = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("condition");
    private final OutputPort conditionInnerSourceElse = (OutputPort)this.getSubprocess(1).getInnerSources().createPort("condition");
    private final MultiOutputPortPairExtender inputExtender = new MultiOutputPortPairExtender("input", this.getInputPorts(), new OutputPorts[]{this.getSubprocess(0).getInnerSources(), this.getSubprocess(1).getInnerSources()});
    private final MultiInputPortPairExtender outputExtender = new MultiInputPortPairExtender("input", this.getOutputPorts(), new InputPorts[]{this.getSubprocess(0).getInnerSinks(), this.getSubprocess(1).getInnerSinks()});

    public ProcessBranch(OperatorDescription description) {
        super(description, "Then", "Else");
        this.inputExtender.start();
        this.getTransformer().addPassThroughRule(this.conditionInput, this.conditionInnerSourceThen);
        this.getTransformer().addPassThroughRule(this.conditionInput, this.conditionInnerSourceElse);
        this.getTransformer().addRule(this.inputExtender.makePassThroughRule());
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(1)));
        this.getTransformer().addRule(this.outputExtender.makePassThroughRule());
        this.outputExtender.start();
    }

    @Override
    public void doWork() throws OperatorException {
        Class conditionClass = null;
        String selectedConditionName = "";
        selectedConditionName = this.getParameterAsString(PARAMETER_CONDITION_TYPE);
        for (int i = 0; i < CONDITION_NAMES.length; ++i) {
            if (!selectedConditionName.toLowerCase().equals(CONDITION_NAMES[i].toLowerCase())) continue;
            conditionClass = CONDITION_CLASSES[i];
            break;
        }
        if (conditionClass == null) {
            try {
                conditionClass = Tools.classForName(selectedConditionName);
            }
            catch (ClassNotFoundException e) {
                throw new UserError((Operator)this, (Throwable)e, 904, selectedConditionName, e);
            }
        }
        ProcessBranchCondition condition = null;
        try {
            condition = (ProcessBranchCondition)conditionClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new UserError((Operator)this, (Throwable)e, 904, selectedConditionName, e);
        }
        catch (IllegalAccessException e) {
            throw new UserError((Operator)this, (Throwable)e, 904, selectedConditionName, e);
        }
        if (condition != null) {
            String conditionValue = null;
            if (CONDITION_INPUT_EXISTS.equals(selectedConditionName)) {
                Class<? extends IOObject> selectedConditionClass = this.getSelectedClass();
                if (selectedConditionClass == null) {
                    throw new UserError((Operator)this, 904, "'" + this.getParameter(PARAMETER_IO_OBJECT) + "'", "Class does not exist.");
                }
                conditionValue = null;
            } else {
                conditionValue = this.getParameterAsString(PARAMETER_CONDITION_VALUE);
            }
            boolean conditionState = condition.check(this, conditionValue);
            this.inputExtender.passDataThrough();
            if (conditionState) {
                this.conditionInnerSourceThen.deliver((IOObject)this.conditionInput.getDataOrNull());
            } else {
                this.conditionInnerSourceElse.deliver((IOObject)this.conditionInput.getDataOrNull());
            }
            int chosenProcess = conditionState ? 0 : 1;
            this.getSubprocess(chosenProcess).execute();
            this.outputExtender.passDataThrough(chosenProcess);
        } else {
            this.outputExtender.passDataThrough(0);
        }
    }

    @Override
    public boolean getAddOnlyAdditionalOutput() {
        return this.getParameterAsBoolean(PARAMETER_RETURN_INNER_OUTPUT);
    }

    public <T extends IOObject> T getConditionInput(Class<T> cls) throws UserError {
        return this.conditionInput.getDataOrNull();
    }

    public Class<? extends IOObject> getSelectedClass() throws UndefinedParameterError {
        int ioType = this.getParameterAsInt(PARAMETER_IO_OBJECT);
        if (this.objectArray == null) {
            return null;
        }
        if (ioType >= 0 && ioType < this.objectArray.length) {
            return OperatorService.getIOObjectClass(this.objectArray[ioType]);
        }
        return null;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeStringCategory(PARAMETER_CONDITION_TYPE, "The condition which is used for the condition check.", CONDITION_NAMES);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeString(PARAMETER_CONDITION_VALUE, "A condition parameter which might be desired for some condition checks.", true);
        type.setExpert(false);
        type.registerDependencyCondition(new NonEqualStringCondition(this, PARAMETER_CONDITION_TYPE, true, CONDITION_INPUT_EXISTS));
        types.add(type);
        Set<String> ioObjects = OperatorService.getIOObjectsNames();
        this.objectArray = new String[ioObjects.size()];
        Iterator<String> i = ioObjects.iterator();
        int index = 0;
        while (i.hasNext()) {
            this.objectArray[index++] = i.next();
        }
        type = new ParameterTypeCategory(PARAMETER_IO_OBJECT, "The class of the object(s) which should be checked for existance.", this.objectArray, 0);
        type.registerDependencyCondition(new EqualStringCondition(this, PARAMETER_CONDITION_TYPE, true, CONDITION_INPUT_EXISTS));
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_RETURN_INNER_OUTPUT, "Indicates if the output of the inner operators should be delivered.", true));
        return types;
    }
}

