/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta.branch;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.meta.branch.ProcessBranch;
import com.rapidminer.operator.meta.branch.ProcessBranchCondition;

public class MinNumberOfExamplesCondition
implements ProcessBranchCondition {
    @Override
    public boolean check(ProcessBranch operator, String value) throws OperatorException {
        if (value == null) {
            throw new UserError((Operator)operator, 205, "condition_value");
        }
        int minNumber = 0;
        try {
            minNumber = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new UserError((Operator)operator, 207, value, "condition_value", e);
        }
        ExampleSet exampleSet = operator.getConditionInput(ExampleSet.class);
        return exampleSet.size() >= minNumber;
    }
}

