/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.learner.CapabilityCheck;
import com.rapidminer.operator.learner.CapabilityProvider;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.ports.metadata.CapabilityPrecondition;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.RandomGenerator;
import java.util.List;

public class XVPrediction
extends OperatorChain
implements CapabilityProvider {
    public static final String PARAMETER_NUMBER_OF_VALIDATIONS = "number_of_validations";
    public static final String PARAMETER_LEAVE_ONE_OUT = "leave_one_out";
    public static final String PARAMETER_SAMPLING_TYPE = "sampling_type";
    private int number;
    private int iteration;
    private final InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private final OutputPort trainingProcessExampleSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("training");
    private final InputPort trainingProcessModelSink = (InputPort)this.getSubprocess(0).getInnerSinks().createPort("model");
    private final PortPairExtender throughExtender = new PortPairExtender("through", this.getSubprocess(0).getInnerSinks(), this.getSubprocess(1).getInnerSources());
    private final OutputPort applyProcessModelSource = (OutputPort)this.getSubprocess(1).getInnerSources().createPort("model");
    private final OutputPort applyProcessExampleSource = (OutputPort)this.getSubprocess(1).getInnerSources().createPort("unlabelled data");
    private final InputPort applyProcessExampleInnerSink = (InputPort)this.getSubprocess(1).getInnerSinks().createPort("labelled data");
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("labelled data");

    public XVPrediction(OperatorDescription description) {
        super(description, "Training", "Model Application");
        this.exampleSetInput.addPrecondition(new CapabilityPrecondition(this, this.exampleSetInput));
        this.throughExtender.start();
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.trainingProcessExampleSource, SetRelation.EQUAL){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) throws UndefinedParameterError {
                try {
                    metaData.setNumberOfExamples(XVPrediction.this.getTrainingSetSize(metaData.getNumberOfExamples()));
                }
                catch (UndefinedParameterError undefinedParameterError) {
                    // empty catch block
                }
                return super.modifyExampleSet(metaData);
            }
        });
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.applyProcessExampleSource, SetRelation.EQUAL){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) throws UndefinedParameterError {
                try {
                    metaData.setNumberOfExamples(XVPrediction.this.getTestSetSize(metaData.getNumberOfExamples()));
                }
                catch (UndefinedParameterError undefinedParameterError) {
                    // empty catch block
                }
                return super.modifyExampleSet(metaData);
            }
        });
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addRule(new PassThroughRule(this.trainingProcessModelSink, this.applyProcessModelSource, false));
        this.getTransformer().addRule(this.throughExtender.makePassThroughRule());
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(1)));
        this.getTransformer().addPassThroughRule(this.applyProcessExampleInnerSink, this.exampleSetOutput);
        this.addValue(new ValueDouble("iteration", "The number of the current iteration."){

            @Override
            public double getDoubleValue() {
                return XVPrediction.this.iteration;
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet inputSet = (ExampleSet)this.exampleSetInput.getData();
        CapabilityCheck check = new CapabilityCheck(this, false);
        check.checkLearnerCapabilities(this, inputSet);
        this.number = this.getParameterAsBoolean(PARAMETER_LEAVE_ONE_OUT) ? inputSet.size() : this.getParameterAsInt(PARAMETER_NUMBER_OF_VALIDATIONS);
        this.log("Starting " + this.number + "-fold cross validation prediction");
        Attribute predictedLabel = PredictionModel.createPredictedLabel(inputSet, inputSet.getAttributes().getLabel());
        List<String> predictedLabelValues = null;
        if (predictedLabel.isNominal()) {
            predictedLabelValues = predictedLabel.getMapping().getValues();
        }
        int samplingType = this.getParameterAsInt(PARAMETER_SAMPLING_TYPE);
        SplittedExampleSet splittedSet = new SplittedExampleSet(inputSet, this.number, samplingType, this.getParameterAsBoolean("use_local_random_seed"), this.getParameterAsInt("local_random_seed"));
        this.iteration = 0;
        while (this.iteration < this.number) {
            splittedSet.selectAllSubsetsBut(this.iteration);
            this.trainingProcessExampleSource.deliver(splittedSet);
            this.getSubprocess(0).execute();
            splittedSet.selectSingleSubset(this.iteration);
            this.applyProcessExampleSource.deliver(splittedSet);
            this.throughExtender.passDataThrough();
            this.applyProcessModelSource.deliver((IOObject)this.trainingProcessModelSink.getData());
            this.getSubprocess(1).execute();
            ExampleSet predictedSet = (ExampleSet)this.applyProcessExampleInnerSink.getData();
            for (int i = 0; i < splittedSet.size(); ++i) {
                Example predictedExample = predictedSet.getExample(i);
                Example inputExample = inputSet.getExample(splittedSet.getActualParentIndex(i));
                inputExample.setValue(predictedLabel, predictedExample.getPredictedLabel());
                if (!predictedLabel.isNominal()) continue;
                for (String s : predictedLabelValues) {
                    inputExample.setConfidence(s, predictedExample.getConfidence(s));
                }
            }
            this.inApplyLoop();
            ++this.iteration;
        }
        this.exampleSetOutput.deliver(inputSet);
    }

    protected MDInteger getTestSetSize(MDInteger originalSize) throws UndefinedParameterError {
        if (this.getParameterAsBoolean(PARAMETER_LEAVE_ONE_OUT)) {
            return new MDInteger(1);
        }
        return originalSize.multiply(1.0 / this.getParameterAsDouble(PARAMETER_NUMBER_OF_VALIDATIONS));
    }

    protected MDInteger getTrainingSetSize(MDInteger originalSize) throws UndefinedParameterError {
        if (this.getParameterAsBoolean(PARAMETER_LEAVE_ONE_OUT)) {
            return originalSize.add(-1);
        }
        return originalSize.multiply(1.0 - 1.0 / this.getParameterAsDouble(PARAMETER_NUMBER_OF_VALIDATIONS));
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_LEAVE_ONE_OUT, "Set the number of validations to the number of examples. If set to true, number_of_validations is ignored.", false, false));
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_NUMBER_OF_VALIDATIONS, "Number of subsets for the crossvalidation.", 2, Integer.MAX_VALUE, 10, false);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_LEAVE_ONE_OUT, false, false));
        types.add(type);
        types.add(new ParameterTypeCategory(PARAMETER_SAMPLING_TYPE, "Defines the sampling type of the cross validation.", SplittedExampleSet.SAMPLING_NAMES, 2));
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }

    @Override
    public boolean supportsCapability(OperatorCapability capability) {
        switch (capability) {
            case NO_LABEL: {
                return false;
            }
        }
        return true;
    }
}

