/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.Condition;
import com.rapidminer.example.set.ConditionCreationException;
import com.rapidminer.example.set.ConditionedExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.AttributeSetPrecondition;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ValueSubgroupIteration
extends OperatorChain {
    public static final String PARAMETER_ATTRIBUTES = "attributes";
    public static final String PARAMETER_VALUES = "values";
    public static final String[] VALUE_OPTIONS = new String[]{"all", "above p"};
    public static final int VALUE_OPTION_ALL = 0;
    public static final int VALUE_OPTION_ABOVE_P = 1;
    public static final String PARAMETER_P = "p";
    public static final String PARAMETER_FILTER_ATTRIBUTE = "filter_attribute";
    public static final String PARAMETER_APPLY_ON_COMPLETE_SET = "apply_on_complete_set";
    public static final String PARAMETER_ITERATION_MACRO = "iteration_macro";
    public static final String DEFAULT_ITERATION_MACRO_NAME = "loop_value";
    private final InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set in");
    private final OutputPort innerExampleSetSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("example set source");

    public ValueSubgroupIteration(OperatorDescription description) {
        super(description, "Subset Processing");
        this.exampleSetInput.addPrecondition(new AttributeSetPrecondition(this.exampleSetInput, new AttributeSetPrecondition.AttributeNameProvider(){

            @Override
            public String[] getRequiredAttributeNames() {
                try {
                    List<String[]> attributeValueOptions = ValueSubgroupIteration.this.getParameterList(ValueSubgroupIteration.PARAMETER_ATTRIBUTES);
                    String[] groupAttributes = new String[attributeValueOptions.size()];
                    int i = 0;
                    for (String[] pair : attributeValueOptions) {
                        groupAttributes[i] = pair[0];
                        ++i;
                    }
                    return groupAttributes;
                }
                catch (UndefinedParameterError e) {
                    return new String[0];
                }
            }
        }, new String[0]));
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.innerExampleSetSource, SetRelation.SUPERSET){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData emd) throws UndefinedParameterError {
                emd.getNumberOfExamples().reduceByUnknownAmount();
                if (ValueSubgroupIteration.this.getParameterAsBoolean(ValueSubgroupIteration.PARAMETER_FILTER_ATTRIBUTE)) {
                    List<String[]> attributeValueOptions = ValueSubgroupIteration.this.getParameterList(ValueSubgroupIteration.PARAMETER_ATTRIBUTES);
                    String[] groupAttributes = new String[attributeValueOptions.size()];
                    int i = 0;
                    for (String[] pair : attributeValueOptions) {
                        groupAttributes[i] = pair[0];
                        ++i;
                    }
                    for (String name : groupAttributes) {
                        AttributeMetaData amd = emd.getAttributeByName(name);
                        if (amd == null) continue;
                        emd.removeAttribute(emd.getAttributeByName(name));
                    }
                }
                return emd;
            }
        });
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(0)));
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        exampleSet.recalculateAllAttributeStatistics();
        List<String[]> attributeValueOptions = this.getParameterList(PARAMETER_ATTRIBUTES);
        LinkedHashMap<Attribute, Integer> attributeValueOptionsMap = new LinkedHashMap<Attribute, Integer>();
        int[] valueOptions = new int[attributeValueOptions.size()];
        Pattern[] attributeRegexPatterns = new Pattern[attributeValueOptions.size()];
        Attribute[] attributes = new Attribute[attributeValueOptions.size()];
        Iterator<String[]> iterator = attributeValueOptions.iterator();
        int j = 0;
        while (iterator.hasNext()) {
            String[] pair = iterator.next();
            String regex = pair[0];
            try {
                attributeRegexPatterns[j] = Pattern.compile(regex);
            }
            catch (PatternSyntaxException e) {
                throw new UserError((Operator)this, 206, regex, e.getMessage());
            }
            attributes[j] = exampleSet.getAttributes().get(pair[0]);
            valueOptions[j] = ((ParameterTypeCategory)((ParameterTypeList)this.getParameterType(PARAMETER_ATTRIBUTES)).getValueType()).getIndex(pair[1]);
            ++j;
        }
        for (int i = 0; i < attributeRegexPatterns.length; ++i) {
            Iterator<Attribute> a = exampleSet.getAttributes().allAttributes();
            while (a.hasNext()) {
                Attribute attribute = a.next();
                Matcher matcher = attributeRegexPatterns[i].matcher(attribute.getName());
                if (!matcher.matches()) continue;
                attributeValueOptionsMap.put(attribute, valueOptions[i]);
            }
        }
        double p = this.getParameterAsDouble(PARAMETER_P);
        boolean filterAttribute = this.getParameterAsBoolean(PARAMETER_FILTER_ATTRIBUTE);
        String iterationMacro = this.getParameterAsString(PARAMETER_ITERATION_MACRO);
        if (this.getParameterAsBoolean(PARAMETER_APPLY_ON_COMPLETE_SET)) {
            if (iterationMacro != null) {
                this.getProcess().getMacroHandler().addMacro(iterationMacro, "ALL");
            }
            this.innerExampleSetSource.deliver(exampleSet);
            this.getSubprocess(0).execute();
        }
        for (Map.Entry attributeEntry : attributeValueOptionsMap.entrySet()) {
            Attribute attribute = (Attribute)attributeEntry.getKey();
            if (!attribute.isNominal()) continue;
            List<String> values = null;
            switch ((Integer)attributeEntry.getValue()) {
                case 0: {
                    values = attribute.getMapping().getValues();
                    break;
                }
                case 1: {
                    values = new Vector<String>();
                    for (String value : attribute.getMapping().getValues()) {
                        if (!(exampleSet.getStatistics(attribute, "count", value) / (double)exampleSet.size() >= p)) continue;
                        values.add(value);
                    }
                    break;
                }
                default: {
                    values = attribute.getMapping().getValues();
                }
            }
            for (String value : values) {
                if (exampleSet.getStatistics(attribute, "count", value) > 0.0) {
                    String className = "attribute_value_filter";
                    String parameter = attribute.getName() + "=" + value;
                    this.log("Creating condition '" + className + "' with parameter '" + parameter + "'");
                    Condition condition = null;
                    try {
                        condition = ConditionedExampleSet.createCondition(className, exampleSet, parameter);
                    }
                    catch (ConditionCreationException e) {
                        throw new UserError((Operator)this, 904, className, e.getMessage());
                    }
                    ConditionedExampleSet subgroupSet = new ConditionedExampleSet(exampleSet, condition, false);
                    if (filterAttribute) {
                        subgroupSet.getAttributes().remove(attribute);
                    }
                    if (iterationMacro != null) {
                        this.getProcess().getMacroHandler().addMacro(iterationMacro, parameter.replace(' ', '_'));
                    }
                    this.innerExampleSetSource.deliver(subgroupSet);
                    this.getSubprocess(0).execute();
                    if (filterAttribute) {
                        subgroupSet.getAttributes().addRegular(attribute);
                    }
                }
                this.inApplyLoop();
            }
        }
        if (iterationMacro != null) {
            this.getProcess().getMacroHandler().addMacro(iterationMacro, null);
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterType type = new ParameterTypeList(PARAMETER_ATTRIBUTES, "The attributes.", (ParameterType)new ParameterTypeAttribute("attribute", "Selects the attribute to build subgroups from.", this.exampleSetInput, 1), (ParameterType)new ParameterTypeCategory(PARAMETER_VALUES, "Values.", VALUE_OPTIONS, 0));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_P, "Threshold of value occurance.", 0.0, 1.0, 0.2);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_FILTER_ATTRIBUTE, "Filter subgroup defining attribute.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_APPLY_ON_COMPLETE_SET, "Apply inner operators also on complete set.", false));
        types.add(new ParameterTypeString(PARAMETER_ITERATION_MACRO, "Name of macro which is set in each iteration.", DEFAULT_ITERATION_MACRO_NAME));
        return types;
    }
}

