/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ValueString;
import com.rapidminer.operator.ports.CollectingPortPairExtender;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.ports.metadata.AttributeParameterPrecondition;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.LinkedList;
import java.util.List;

public class ValueIteration
extends OperatorChain {
    public static final String PARAMETER_ATTRIBUTE = "attribute";
    public static final String PARAMETER_ITERATION_MACRO = "iteration_macro";
    public static final String DEFAULT_ITERATION_MACRO_NAME = "loop_value";
    private String currentValue = null;
    private final InputPort exampleSetInput = this.getInputPorts().createPort("example set", new ExampleSetMetaData());
    private final OutputPort exampleInnerSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("example set");
    private final CollectingPortPairExtender outExtender = new CollectingPortPairExtender("out", this.getSubprocess(0).getInnerSinks(), this.getOutputPorts());

    public ValueIteration(OperatorDescription description) {
        super(description, "Iteration");
        this.outExtender.start();
        this.exampleSetInput.addPrecondition(new AttributeParameterPrecondition(this.exampleSetInput, this, PARAMETER_ATTRIBUTE, 1));
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleInnerSource);
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addRule(this.outExtender.makePassThroughRule());
        this.addValue(new ValueString("current_value", "The nominal value of the current loop."){

            @Override
            public String getStringValue() {
                return ValueIteration.this.currentValue;
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        exampleSet.recalculateAllAttributeStatistics();
        this.outExtender.reset();
        String attributeName = this.getParameterAsString(PARAMETER_ATTRIBUTE);
        Attribute attribute = exampleSet.getAttributes().get(attributeName);
        if (attribute == null) {
            throw new UserError((Operator)this, 111, attributeName);
        }
        if (!attribute.isNominal()) {
            throw new UserError((Operator)this, 119, attributeName, this.getName());
        }
        String iterationMacro = this.getParameterAsString(PARAMETER_ITERATION_MACRO);
        LinkedList<String> values = new LinkedList<String>(attribute.getMapping().getValues());
        for (String value : values) {
            if (exampleSet.getStatistics(attribute, "count", value) > 0.0) {
                if (iterationMacro != null) {
                    this.getProcess().getMacroHandler().addMacro(iterationMacro, value);
                }
                this.currentValue = value;
                this.exampleInnerSource.deliver((ExampleSet)exampleSet.clone());
                this.getSubprocess(0).execute();
                for (PortPairExtender.PortPair pair : this.outExtender.getManagedPairs()) {
                    Object result = pair.getInputPort().getDataOrNull();
                    if (result == null) continue;
                    result.setSource(this.getName() + ":" + value);
                }
                this.outExtender.collect();
            }
            this.inApplyLoop();
        }
        if (iterationMacro != null) {
            this.getProcess().getMacroHandler().addMacro(iterationMacro, null);
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeAttribute type = new ParameterTypeAttribute(PARAMETER_ATTRIBUTE, "The nominal attribute for which the iteration should be defined", this.exampleSetInput, false);
        types.add(type);
        types.add(new ParameterTypeString(PARAMETER_ITERATION_MACRO, "Name of macro which is set in each iteration.", DEFAULT_ITERATION_MACRO_NAME, false));
        return types;
    }
}

