/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.meta.AbstractIteratingOperatorChain;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import java.util.List;

public class RepeatUntilOperatorChain
extends AbstractIteratingOperatorChain {
    public static final String PARAMETER_MIN_ATTRIBUTES = "min_attributes";
    public static final String PARAMETER_MAX_ATTRIBUTES = "max_attributes";
    public static final String PARAMETER_MIN_EXAMPLES = "min_examples";
    public static final String PARAMETER_MAX_EXAMPLES = "max_examples";
    public static final String PARAMETER_MIN_CRITERION = "min_criterion";
    public static final String PARAMETER_MAX_CRITERION = "max_criterion";
    public static final String PARAMETER_MAX_ITERATIONS = "max_iterations";
    public static final String PARAMETER_LIMIT_TIME = "limit_time";
    public static final String PARAMETER_TIMEOUT = "timeout";
    public static final String PARAMETER_PERFORMANCE_CHANGE = "performance_change";
    public static final String PARAMETER_CONDITION_BEFORE = "condition_before";
    public static final String[] COMPARISONS = new String[]{"none", "decreasing", "non-increasing"};
    public static final int NONE = 0;
    public static final int DECREASING = 1;
    public static final int NONINCREASING = 2;
    private long stoptime;
    private double fitness;
    private final InputPort performanceConditionInput = this.getSubprocess(0).getInnerSinks().createPort("performance", PerformanceVector.class);
    private final InputPort exampleSetConditionInput = this.getSubprocess(0).getInnerSinks().createPort("example set", ExampleSet.class);

    public RepeatUntilOperatorChain(OperatorDescription description) {
        super(description);
    }

    @Override
    public void doWork() throws OperatorException {
        this.stoptime = Long.MAX_VALUE;
        if (!this.getParameterAsBoolean(PARAMETER_LIMIT_TIME)) {
            this.stoptime = System.currentTimeMillis() + 60000L * (long)this.getParameterAsInt(PARAMETER_TIMEOUT);
        }
        this.fitness = Double.NEGATIVE_INFINITY;
        super.doWork();
    }

    private boolean evaluateCondition(IOContainer input) throws OperatorException {
        int nrEx;
        int nrAtts;
        double crit;
        if (this.getIteration() == 0 && !this.getParameterAsBoolean(PARAMETER_CONDITION_BEFORE)) {
            return false;
        }
        int maxit = this.getParameterAsInt(PARAMETER_MAX_ITERATIONS);
        if (this.getIteration() >= maxit) {
            this.getLogger().fine("Maximum number of iterations met.");
            return true;
        }
        if (System.currentTimeMillis() > this.stoptime) {
            this.getLogger().fine("Runtime exceeded.");
            return true;
        }
        PerformanceVector performanceVector = (PerformanceVector)this.performanceConditionInput.getData();
        int changeType = this.getParameterAsInt(PARAMETER_PERFORMANCE_CHANGE);
        if (changeType != 0 && this.getIteration() > 0) {
            double currentFitness = performanceVector.getMainCriterion().getFitness();
            if (changeType == 1 && currentFitness < this.fitness) {
                return true;
            }
            if (changeType == 2 && currentFitness <= this.fitness) {
                return true;
            }
            this.fitness = currentFitness;
        }
        double maxCrit = this.getParameterAsDouble(PARAMETER_MAX_CRITERION);
        double minCrit = this.getParameterAsDouble(PARAMETER_MIN_CRITERION);
        if ((maxCrit < Double.POSITIVE_INFINITY || minCrit > Double.NEGATIVE_INFINITY) && ((crit = performanceVector.getMainCriterion().getAverage()) > maxCrit || crit < minCrit)) {
            return false;
        }
        ExampleSet exampleSet = (ExampleSet)this.exampleSetConditionInput.getData();
        int maxAtts = this.getParameterAsInt(PARAMETER_MAX_ATTRIBUTES);
        int minAtts = this.getParameterAsInt(PARAMETER_MIN_ATTRIBUTES);
        if (!(maxAtts >= Integer.MAX_VALUE && minAtts <= 0 || (nrAtts = exampleSet.getAttributes().size()) <= maxAtts && nrAtts >= minAtts)) {
            return false;
        }
        int maxEx = this.getParameterAsInt(PARAMETER_MAX_EXAMPLES);
        int minEx = this.getParameterAsInt(PARAMETER_MIN_EXAMPLES);
        if (!(maxEx >= Integer.MAX_VALUE && minEx <= 0 || (nrEx = exampleSet.size()) <= maxEx && nrEx >= minEx)) {
            return false;
        }
        this.getLogger().fine("All criteria met.");
        return true;
    }

    @Override
    boolean shouldStop(IOContainer iterationResults) throws OperatorException {
        return this.evaluateCondition(iterationResults);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeInt(PARAMETER_MIN_ATTRIBUTES, "Minimal number of attributes in first example set", 0, Integer.MAX_VALUE, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MAX_ATTRIBUTES, "Maximal number of attributes in first example set", 0, Integer.MAX_VALUE, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MIN_EXAMPLES, "Minimal number of examples in first example set", 0, Integer.MAX_VALUE, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MAX_EXAMPLES, "Maximal number of examples in first example set", 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_MIN_CRITERION, "Minimal main criterion in first performance vector", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_MAX_CRITERION, "Maximal main criterion in first performance vector", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MAX_ITERATIONS, "Maximum number of iterations", 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        type.setExpert(true);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_LIMIT_TIME, "If checked, the loop will be aborted at last after a specified time.", false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_TIMEOUT, "Timeout in minutes", 1, Integer.MAX_VALUE, 1);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_LIMIT_TIME, true, true));
        type.setExpert(true);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_PERFORMANCE_CHANGE, "Stop when performance of inner chain behaves like this.", COMPARISONS, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_CONDITION_BEFORE, "Evaluate condition before inner chain is applied (true) or after?", true);
        type.setExpert(true);
        types.add(type);
        return types;
    }
}

