/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.meta.AbstractSplitChain;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.RandomGenerator;
import java.util.List;

public class RatioSplitChain
extends AbstractSplitChain {
    public static final String PARAMETER_SPLIT_RATIO = "split_ratio";
    public static final String PARAMETER_SAMPLING_TYPE = "sampling_type";

    public RatioSplitChain(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MDInteger getNumberOfExamplesFirst(MDInteger numberOfExamples) throws UndefinedParameterError {
        return numberOfExamples.multiply(this.getParameterAsDouble(PARAMETER_SPLIT_RATIO));
    }

    @Override
    protected MDInteger getNumberOfExamplesSecond(MDInteger numberOfExamples) throws UndefinedParameterError {
        return numberOfExamples.multiply(1.0 - this.getParameterAsDouble(PARAMETER_SPLIT_RATIO));
    }

    @Override
    protected SplittedExampleSet createSplittedExampleSet(ExampleSet inputSet) throws OperatorException {
        return new SplittedExampleSet(inputSet, this.getParameterAsDouble(PARAMETER_SPLIT_RATIO), this.getParameterAsInt(PARAMETER_SAMPLING_TYPE), this.getParameterAsBoolean("use_local_random_seed"), this.getParameterAsInt("local_random_seed"));
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeDouble type = new ParameterTypeDouble(PARAMETER_SPLIT_RATIO, "Relative size of the first set. The remaining examples will be part of the second set.", 0.0, 1.0, 0.7);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory(PARAMETER_SAMPLING_TYPE, "Defines the sampling type of this operator.", SplittedExampleSet.SAMPLING_NAMES, 1));
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }
}

