/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.SimpleOperatorChain;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import java.util.List;

public class RandomOptimizationChain
extends SimpleOperatorChain {
    public static final String PARAMETER_ITERATIONS = "iterations";
    public static final String PARAMETER_TIMEOUT = "timeout";
    public static final String PARAMETER_ENABLE_TIMEOUT = "enable_timeout";
    private int iterationValue;
    private double bestPerformanceValue = 0.0;
    private double avgPerformanceValue = 0.0;
    private final InputPort innerPerformanceSink = this.getSubprocess(0).getInnerSinks().createPort("performance vector", PerformanceVector.class);
    private final OutputPort performanceOutput = (OutputPort)this.getOutputPorts().createPort("performance");

    public RandomOptimizationChain(OperatorDescription description) {
        super(description, "Optimizing");
        this.getTransformer().addGenerationRule(this.performanceOutput, PerformanceVector.class);
        this.addValue(new ValueDouble("iteration", "The number of the current iteration."){

            @Override
            public double getDoubleValue() {
                return RandomOptimizationChain.this.iterationValue;
            }
        });
        this.addValue(new ValueDouble("performance", "The current best performance"){

            @Override
            public double getDoubleValue() {
                return RandomOptimizationChain.this.bestPerformanceValue;
            }
        });
        this.addValue(new ValueDouble("avg_performance", "The average performance"){

            @Override
            public double getDoubleValue() {
                return RandomOptimizationChain.this.avgPerformanceValue;
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        int maxIterations = this.getParameterAsInt(PARAMETER_ITERATIONS);
        int timeout = this.getParameterAsInt(PARAMETER_TIMEOUT);
        long stoptime = !this.getParameterAsBoolean(PARAMETER_ENABLE_TIMEOUT) ? Long.MAX_VALUE : System.currentTimeMillis() + 60000L * (long)timeout;
        double perfSum = 0.0;
        List bestResult = null;
        PerformanceVector bestPerformance = null;
        this.iterationValue = 0;
        while (this.iterationValue < maxIterations) {
            super.doWork();
            PerformanceVector performanceVector = (PerformanceVector)this.innerPerformanceSink.getData();
            if (bestPerformance == null) {
                bestPerformance = performanceVector;
                bestResult = this.outputExtender.getData();
            } else if (performanceVector.getMainCriterion().compareTo(bestPerformance.getMainCriterion()) == 1) {
                bestPerformance = performanceVector;
                bestResult = this.outputExtender.getData();
            }
            this.bestPerformanceValue = bestPerformance.getMainCriterion().getFitness();
            this.avgPerformanceValue = (perfSum += performanceVector.getMainCriterion().getAverage()) / (double)this.iterationValue;
            if (System.currentTimeMillis() > stoptime) {
                this.log("Runtime exceeded in iteration " + this.iterationValue + ".");
                break;
            }
            this.inApplyLoop();
            ++this.iterationValue;
        }
        this.outputExtender.deliver(bestResult);
        this.performanceOutput.deliver(bestPerformance);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_ITERATIONS, "The number of iterations to perform", 1, Integer.MAX_VALUE, 10, false));
        types.add(new ParameterTypeBoolean(PARAMETER_ENABLE_TIMEOUT, "If used the processing will be aborted after the next completed execution of child operators.", false, true));
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_TIMEOUT, "Timeout in minutes", 1, Integer.MAX_VALUE, 1);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_ENABLE_TIMEOUT, true, true));
        types.add(type);
        return types;
    }
}

