/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import Jama.Matrix;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.meta.GridSearchParameterOptimizationOperator;
import com.rapidminer.operator.meta.ParameterSet;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import java.util.List;

public class QuadraticParameterOptimizationOperator
extends GridSearchParameterOptimizationOperator {
    public static final String PARAMETER_IF_EXCEEDS_REGION = "if_exceeds_region";
    public static final String PARAMETER_IF_EXCEEDS_RANGE = "if_exceeds_range";
    private static final String[] EXCEED_BEHAVIORS = new String[]{"ignore", "clip", "fail"};
    private static final int IGNORE = 0;
    private static final int CLIP = 1;
    private static final int FAIL = 2;
    private ParameterSet best;

    public QuadraticParameterOptimizationOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public double getCurrentBestPerformance() {
        if (this.best != null) {
            return this.best.getPerformance().getMainCriterion().getAverage();
        }
        return Double.NaN;
    }

    @Override
    public void doWork() throws OperatorException {
        this.getParametersToOptimize();
        int ifExceedsRegion = this.getParameterAsInt(PARAMETER_IF_EXCEEDS_REGION);
        int ifExceedsRange = this.getParameterAsInt(PARAMETER_IF_EXCEEDS_RANGE);
        for (int index = 0; index < this.numberOfParameters; ++index) {
            String[] valuesToSort = this.values[index];
            for (int ind1 = 0; ind1 < valuesToSort.length; ++ind1) {
                double val1 = Double.parseDouble(valuesToSort[ind1]);
                for (int ind2 = ind1 + 1; ind2 < valuesToSort.length; ++ind2) {
                    double val2 = Double.parseDouble(valuesToSort[ind2]);
                    if (!(val1 > val2)) continue;
                    String s = valuesToSort[ind1];
                    valuesToSort[ind1] = valuesToSort[ind2];
                    valuesToSort[ind2] = s;
                    val1 = val2;
                }
            }
        }
        int[] bestIndex = new int[this.numberOfParameters];
        ParameterSet[] allParameters = new ParameterSet[this.numberOfCombinations];
        int paramIndex = 0;
        this.best = null;
        while (true) {
            boolean ok;
            block51: {
                int j;
                this.getLogger().fine("Using parameter set");
                for (int j2 = 0; j2 < this.operators.length; ++j2) {
                    this.operators[j2].getParameters().setParameter(this.parameters[j2], this.values[j2][this.currentIndex[j2]]);
                    this.getLogger().fine(this.operators[j2] + "." + this.parameters[j2] + " = " + this.values[j2][this.currentIndex[j2]]);
                }
                PerformanceVector performance = this.getPerformance(true);
                String[] currentValues = new String[this.parameters.length];
                for (j = 0; j < this.parameters.length; ++j) {
                    currentValues[j] = this.values[j][this.currentIndex[j]];
                }
                allParameters[paramIndex] = new ParameterSet(this.operators, this.parameters, currentValues, performance);
                if (this.best == null || performance.compareTo(this.best.getPerformance()) > 0) {
                    this.best = allParameters[paramIndex];
                    for (j = 0; j < this.numberOfParameters; ++j) {
                        bestIndex[j] = this.currentIndex[j];
                    }
                }
                int k = 0;
                ok = true;
                do {
                    int n = k;
                    this.currentIndex[n] = this.currentIndex[n] + 1;
                    if (this.currentIndex[n] < this.values[k].length) break block51;
                    this.currentIndex[k] = 0;
                } while (++k < this.currentIndex.length);
                ok = false;
            }
            if (!ok) break;
            ++paramIndex;
        }
        int nrParameters = 0;
        for (int i = 0; i < this.numberOfParameters; ++i) {
            if (this.values[i].length > 2) {
                this.log("Param " + i + ", bestI = " + bestIndex[i]);
                ++nrParameters;
                if (bestIndex[i] == 0) {
                    int n = i;
                    bestIndex[n] = bestIndex[n] + 1;
                }
                if (bestIndex[i] != this.values[i].length - 1) continue;
                int n = i;
                bestIndex[n] = bestIndex[n] - 1;
                continue;
            }
            this.getLogger().warning("Parameter " + this.parameters[i] + " has less than 3 values, skipped.");
        }
        if (nrParameters > 3) {
            this.getLogger().warning("Optimization not recommended for more than 3 values. Check results carefully!");
        }
        if (nrParameters > 0) {
            int j;
            int i;
            int threetok = 1;
            for (int i2 = 0; i2 < nrParameters; ++i2) {
                threetok *= 3;
            }
            this.log("Optimising " + nrParameters + " parameters");
            Matrix designMatrix = new Matrix(threetok, nrParameters + nrParameters * (nrParameters + 1) / 2 + 1);
            Matrix y = new Matrix(threetok, 1);
            paramIndex = 0;
            for (int i3 = this.numberOfParameters - 1; i3 >= 0; --i3) {
                this.currentIndex[i3] = this.values[i3].length > 2 ? bestIndex[i3] - 1 : bestIndex[i3];
                paramIndex = paramIndex * this.values[i3].length + this.currentIndex[i3];
            }
            block13: for (int row = 0; row < designMatrix.getRowDimension(); ++row) {
                int i4;
                y.set(row, 0, allParameters[paramIndex].getPerformance().getMainCriterion().getFitness());
                designMatrix.set(row, 0, 1.0);
                int c = 1;
                for (i4 = 0; i4 < nrParameters; ++i4) {
                    if (this.values[i4].length <= 2) continue;
                    designMatrix.set(row, c, Double.parseDouble(this.values[i4][this.currentIndex[i4]]));
                    ++c;
                }
                for (i4 = 0; i4 < nrParameters; ++i4) {
                    if (this.values[i4].length <= 2) continue;
                    for (int j3 = i4 + 1; j3 < nrParameters; ++j3) {
                        if (this.values[j3].length <= 2) continue;
                        designMatrix.set(row, c, Double.parseDouble(this.values[i4][this.currentIndex[i4]]) * Double.parseDouble(this.values[j3][this.currentIndex[j3]]));
                        ++c;
                    }
                }
                for (i4 = 0; i4 < nrParameters; ++i4) {
                    if (this.values[i4].length <= 2) continue;
                    designMatrix.set(row, c, Double.parseDouble(this.values[i4][this.currentIndex[i4]]) * Double.parseDouble(this.values[i4][this.currentIndex[i4]]));
                    ++c;
                }
                int k = 0;
                c = 1;
                while (k < this.numberOfParameters) {
                    if (this.values[k].length > 2) {
                        int n = k;
                        this.currentIndex[n] = this.currentIndex[n] + 1;
                        paramIndex += c;
                        if (this.currentIndex[k] <= bestIndex[k] + 1) continue block13;
                        this.currentIndex[k] = bestIndex[k] - 1;
                        paramIndex -= 3 * c;
                        c *= this.values[k].length;
                        ++k;
                        continue;
                    }
                    c *= this.values[k].length;
                    ++k;
                }
            }
            Matrix beta = designMatrix.solve(y);
            for (int i5 = 0; i5 < designMatrix.getColumnDimension(); ++i5) {
                this.logWarning(" -- Writing " + beta.get(i5, 0) + " at position " + i5 + " in vector b");
            }
            Matrix p = new Matrix(nrParameters, nrParameters);
            int betapos = nrParameters + 1;
            for (int j4 = 0; j4 < nrParameters - 1; ++j4) {
                for (i = 1 + j4; i < nrParameters; ++i) {
                    p.set(i, j4, beta.get(betapos, 0) * 0.5);
                    p.set(j4, i, beta.get(betapos, 0) * 0.5);
                    ++betapos;
                }
            }
            for (int i6 = 0; i6 < nrParameters; ++i6) {
                p.set(i6, i6, beta.get(betapos, 0));
                ++betapos;
            }
            Matrix y2 = new Matrix(nrParameters, 1);
            for (i = 0; i < nrParameters; ++i) {
                y2.set(i, 0, beta.get(i + 1, 0));
            }
            y2 = y2.times(-0.5);
            Matrix x = new Matrix(nrParameters, 1);
            try {
                x = p.solve(y2);
            }
            catch (RuntimeException e) {
                this.logWarning("Quadratic optimization failed. (invalid matrix)");
            }
            String[] Qvalues = new String[this.numberOfParameters];
            int pc = 0;
            boolean ok = true;
            for (j = 0; j < this.numberOfParameters; ++j) {
                if (this.values[j].length > 2) {
                    if (x.get(pc, 0) > Double.parseDouble(this.values[j][bestIndex[j] + 1]) || x.get(pc, 0) < Double.parseDouble(this.values[j][bestIndex[j] - 1])) {
                        this.logWarning("Parameter " + this.parameters[j] + " exceeds region of interest (" + x.get(pc, 0) + ")");
                        if (ifExceedsRegion == 1) {
                            if (x.get(pc, 0) > Double.parseDouble(this.values[j][bestIndex[j] + 1])) {
                                x.set(pc, 0, Double.parseDouble(this.values[j][bestIndex[j] + 1]));
                            } else {
                                x.set(pc, 0, Double.parseDouble(this.values[j][bestIndex[j] - 1]));
                            }
                        } else if (ifExceedsRegion == 2) {
                            ok = false;
                        }
                    }
                    if (x.get(pc, 0) < Double.parseDouble(this.values[j][0]) || x.get(pc, 0) > Double.parseDouble(this.values[j][this.values[j].length - 1])) {
                        this.logWarning("Parameter " + this.parameters[j] + " exceeds range (" + x.get(pc, 0) + ")");
                        if (ifExceedsRange == 0) {
                            this.logWarning("  but no measures taken. Check parameters manually!");
                        } else if (ifExceedsRange == 1) {
                            if (x.get(pc, 0) > Double.parseDouble(this.values[j][0])) {
                                x.set(pc, 0, Double.parseDouble(this.values[j][0]));
                            } else {
                                x.set(pc, 0, Double.parseDouble(this.values[j][this.values[j].length - 1]));
                            }
                        } else {
                            ok = false;
                        }
                    }
                    Qvalues[j] = x.get(pc, 0) + "";
                    ++pc;
                    continue;
                }
                Qvalues[j] = this.values[j][bestIndex[j]];
            }
            this.getLogger().info("Optimised parameter set:");
            for (j = 0; j < this.operators.length; ++j) {
                this.operators[j].getParameters().setParameter(this.parameters[j], Qvalues[j]);
                this.getLogger().info("  " + this.operators[j] + "." + this.parameters[j] + " = " + Qvalues[j]);
            }
            if (ok) {
                PerformanceVector qPerformance = super.getPerformance(true);
                this.log("Old: " + this.best.getPerformance().getMainCriterion().getFitness());
                this.log("New: " + qPerformance.getMainCriterion().getFitness());
                if (qPerformance.compareTo(this.best.getPerformance()) > 0) {
                    this.best = new ParameterSet(this.operators, this.parameters, Qvalues, qPerformance);
                    this.log("Optimised parameter set does increase the performance");
                } else {
                    this.log("Could not increase performance by quadratic optimization");
                }
            } else {
                this.getLogger().warning("Parameters outside admissible range, not using optimised parameter set.");
            }
        } else {
            this.getLogger().warning("No parameters to optimize");
        }
        this.deliver(this.best);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeCategory(PARAMETER_IF_EXCEEDS_REGION, "What to do if range is exceeded.", EXCEED_BEHAVIORS, 1));
        types.add(new ParameterTypeCategory(PARAMETER_IF_EXCEEDS_RANGE, "What to do if range is exceeded.", EXCEED_BEHAVIORS, 2));
        return types;
    }
}

