/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.Process;
import com.rapidminer.RepositoryProcessLocation;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessRootOperator;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPortExtender;
import com.rapidminer.operator.ports.OutputPortExtender;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeRepositoryLocation;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.ProcessEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.tools.Observable;
import com.rapidminer.tools.Observer;
import com.rapidminer.tools.XMLException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ProcessEmbeddingOperator
extends Operator {
    private final InputPortExtender inputExtender = new InputPortExtender("input", this.getInputPorts());
    private final OutputPortExtender outputExtender = new OutputPortExtender("result", this.getOutputPorts());
    public static final String PARAMETER_PROCESS_FILE = "process_location";
    public static final String PARAMETER_USE_INPUT = "use_input";
    public static final String PARAMETER_PROPAGATE_METADATA_RECURSIVELY = "propagate_metadata_recursively";
    public static final String PARAMETER_MACROS = "macros";
    public static final String PARAMETER_MACRO_NAME = "macro_name";
    public static final String PARAMETER_MACRO_VALUE = "macro_value";
    private Process cachedProcess;
    private ProcessSetupError cachedError = null;

    public ProcessEmbeddingOperator(OperatorDescription description) {
        super(description);
        this.inputExtender.start();
        this.outputExtender.start();
        this.getParameters().addObserver(new Observer<String>(){

            @Override
            public void update(Observable<String> observable, String arg) {
                ProcessEmbeddingOperator.this.cachedProcess = null;
                ProcessEmbeddingOperator.this.cachedError = null;
            }
        }, false);
        this.getTransformer().addRule(new MDTransformationRule(){

            @Override
            public void transformMD() {
                if (ProcessEmbeddingOperator.this.getParameterAsBoolean(ProcessEmbeddingOperator.PARAMETER_PROPAGATE_METADATA_RECURSIVELY) && ProcessEmbeddingOperator.this.cachedProcess != null) {
                    int consumes;
                    int delivers;
                    int gets;
                    ProcessRootOperator root = ProcessEmbeddingOperator.this.cachedProcess.getRootOperator();
                    int requires = root.getSubprocess(0).getInnerSources().getNumberOfConnectedPorts();
                    if (requires != (gets = ProcessEmbeddingOperator.this.getInputPorts().getNumberOfConnectedPorts())) {
                        ((InputPort)ProcessEmbeddingOperator.this.getInputPorts().getPortByIndex(0)).addError(new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)ProcessEmbeddingOperator.this.getInputPorts().getPortByIndex(0), "included_process_input_mismatch", requires, gets));
                    }
                    if ((delivers = root.getSubprocess(0).getInnerSinks().getNumberOfConnectedPorts()) != (consumes = ProcessEmbeddingOperator.this.getOutputPorts().getNumberOfConnectedPorts())) {
                        ((InputPort)ProcessEmbeddingOperator.this.getInputPorts().getPortByIndex(0)).addError(new SimpleMetaDataError(ProcessSetupError.Severity.WARNING, (Port)ProcessEmbeddingOperator.this.getInputPorts().getPortByIndex(0), "included_process_output_mismatch", delivers, consumes));
                    }
                    if (ProcessEmbeddingOperator.this.getParameterAsBoolean(ProcessEmbeddingOperator.PARAMETER_USE_INPUT)) {
                        root.deliverInputMD(ProcessEmbeddingOperator.this.inputExtender.getMetaData(false));
                    }
                    root.transformMetaData();
                    List<MetaData> result = root.getResultMetaData();
                    ProcessEmbeddingOperator.this.outputExtender.deliverMetaData(result);
                }
            }
        });
    }

    @Override
    protected void performAdditionalChecks() {
        super.performAdditionalChecks();
        if (this.getParameterAsBoolean(PARAMETER_PROPAGATE_METADATA_RECURSIVELY)) {
            if (this.cachedProcess == null) {
                try {
                    this.cachedProcess = this.loadIncludedProcess();
                }
                catch (Exception e) {
                    this.cachedError = new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), "cannot_load_included_process", e.getMessage());
                    this.addError(this.cachedError);
                }
            } else if (this.cachedError != null) {
                this.addError(this.cachedError);
            }
        }
    }

    @Override
    public void doWork() throws OperatorException {
        Process process;
        try {
            process = this.loadIncludedProcess();
        }
        catch (RepositoryException e) {
            throw new UserError((Operator)this, (Throwable)e, 312, this.getParameterAsString(PARAMETER_PROCESS_FILE), e.getMessage());
        }
        HashMap<String, String> macroMap = new HashMap<String, String>();
        List<String[]> macros = this.getParameterList(PARAMETER_MACROS);
        if (macros != null) {
            for (String[] macroPair : macros) {
                String macroName = macroPair[0];
                String macroValue = macroPair[1];
                macroMap.put(macroName, macroValue);
            }
        }
        IOContainer result = null;
        result = this.getParameterAsBoolean(PARAMETER_USE_INPUT) ? process.run(new IOContainer(this.inputExtender.getData(false)), -1, true, macroMap) : process.run(new IOContainer(), -1, true, macroMap);
        this.outputExtender.deliver(Arrays.asList(result.getIOObjects()));
    }

    private Process loadIncludedProcess() throws UndefinedParameterError, UserError, RepositoryException {
        RepositoryLocation location = this.getParameterAsRepositoryLocation(PARAMETER_PROCESS_FILE);
        Entry entry = location.locateEntry();
        if (entry == null) {
            throw new RepositoryException("Entry '" + location + "' does not exist.");
        }
        if (entry instanceof ProcessEntry) {
            Process process;
            try {
                process = new RepositoryProcessLocation(location).load(null);
                process.setRepositoryAccessor(this.getProcess().getRepositoryAccessor());
            }
            catch (IOException e) {
                throw new UserError((Operator)this, 302, location, e.getMessage());
            }
            catch (XMLException e) {
                throw new UserError((Operator)this, 401, e.getMessage());
            }
            return process;
        }
        throw new RepositoryException("Entry '" + location + "' is not a data entry, but " + entry.getType());
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeRepositoryLocation(PARAMETER_PROCESS_FILE, "The process location which should be encapsulated by this operator", false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_INPUT, "Indicates if the operator input should be used as input of the process", false));
        types.add(new ParameterTypeBoolean(PARAMETER_PROPAGATE_METADATA_RECURSIVELY, "Determines whether meta data is propagated through the included process.", false));
        types.add(new ParameterTypeList(PARAMETER_MACROS, "Defines macros for this sub-process.", (ParameterType)new ParameterTypeString(PARAMETER_MACRO_NAME, "The name of the macro.", false), (ParameterType)new ParameterTypeString(PARAMETER_MACRO_VALUE, "The value of the macro.", false), true));
        return types;
    }
}

