/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.RandomGenerator;
import java.util.List;

public class PartialExampleSetLearner
extends OperatorChain {
    private final InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set");
    private final OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("model");
    private final OutputPort exampleSubsetInnerSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("example subset");
    private final InputPort modelInnerSink = this.getSubprocess(0).getInnerSinks().createPort("model", Model.class);
    public static final String PARAMETER_FRACTION = "fraction";
    public static final String PARAMETER_SAMPLING_TYPE = "sampling_type";

    public PartialExampleSetLearner(OperatorDescription description) {
        super(description, "Learning Process");
        this.exampleSetInput.addPrecondition(new ExampleSetPrecondition(this.exampleSetInput, new String[0], 0, "label"));
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.exampleSubsetInnerSource, SetRelation.EQUAL){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) throws UndefinedParameterError {
                metaData.getNumberOfExamples().multiply(PartialExampleSetLearner.this.getParameterAsDouble(PartialExampleSetLearner.PARAMETER_FRACTION));
                return super.modifyExampleSet(metaData);
            }
        });
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addRule(new PassThroughRule(this.modelInnerSink, this.modelOutput, false));
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet originalExampleSet = (ExampleSet)this.exampleSetInput.getData();
        double fraction = this.getParameterAsDouble(PARAMETER_FRACTION);
        if (fraction < 0.0 || fraction > 1.0) {
            throw new UserError((Operator)this, 207, fraction, PARAMETER_FRACTION, "Cannot use fractions of less than 0.0 or more than 1.0");
        }
        SplittedExampleSet splitted = new SplittedExampleSet(originalExampleSet, fraction, this.getParameterAsInt(PARAMETER_SAMPLING_TYPE), this.getParameterAsBoolean("use_local_random_seed"), this.getParameterAsInt("local_random_seed"));
        splitted.selectSingleSubset(0);
        this.exampleSubsetInnerSource.deliver(splitted);
        this.getSubprocess(0).execute();
        this.modelOutput.deliver((IOObject)this.modelInnerSink.getData());
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeDouble type = new ParameterTypeDouble(PARAMETER_FRACTION, "The fraction of examples which shall be used.", 0.0, 1.0, 0.05);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory(PARAMETER_SAMPLING_TYPE, "Defines the sampling type (linear = consecutive subsets, shuffled = random subsets, stratified = random subsets with class distribution kept constant)", SplittedExampleSet.SAMPLING_NAMES, 2));
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }
}

