/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.Process;
import com.rapidminer.operator.Operator;
import java.io.Serializable;
import java.util.Map;

public class ParameterValue
implements Serializable {
    private static final long serialVersionUID = -6847818423564185071L;
    private final String operator;
    private final String parameterKey;
    private final String parameterValue;

    public ParameterValue(String operator, String parameterKey, String parameterValue) {
        this.operator = operator;
        this.parameterKey = parameterKey;
        this.parameterValue = parameterValue;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getParameterKey() {
        return this.parameterKey;
    }

    public String getParameterValue() {
        return this.parameterValue;
    }

    public String toString() {
        return this.operator + "." + this.parameterKey + "\t= " + this.parameterValue;
    }

    public void apply(Process process, Map<String, String> nameTranslation) {
        String opName = null;
        if (nameTranslation != null) {
            opName = nameTranslation.get(this.operator);
        }
        if (opName == null) {
            opName = this.operator;
        }
        process.getLogger().fine("Setting parameter '" + this.parameterKey + "' of operator '" + opName + "' to '" + this.parameterValue + "'.");
        Operator operator = process.getOperator(opName);
        if (operator == null) {
            process.getLogger().warning("No such operator: '" + opName + "'.");
        } else {
            operator.getParameters().setParameter(this.parameterKey, this.parameterValue);
        }
    }
}

