/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.meta.ParameterSet;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.quickfix.DictionaryQuickFix;
import com.rapidminer.operator.ports.quickfix.ParameterSettingQuickFix;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class ParameterSetter
extends Operator {
    public static final String PARAMETER_NAME_MAP = "name_map";
    private InputPort parameterInput = this.getInputPorts().createPort("parameter set", ParameterSet.class);

    public ParameterSetter(OperatorDescription description) {
        super(description);
    }

    @Override
    public void doWork() throws OperatorException {
        ParameterSet parameterSet = (ParameterSet)this.parameterInput.getData();
        HashMap<String, String> nameMap = new HashMap<String, String>();
        List<String[]> nameList = this.getParameterList(PARAMETER_NAME_MAP);
        for (String[] keyValue : nameList) {
            nameMap.put(keyValue[0], keyValue[1]);
        }
        parameterSet.applyAll(this.getProcess(), nameMap);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeList type = new ParameterTypeList(PARAMETER_NAME_MAP, "A list mapping operator names from the parameter set to operator names in the process setup.", (ParameterType)new ParameterTypeString("set_operator_name", "The name of the operator in the parameter set."), (ParameterType)new ParameterTypeString("operator_name", "The name of an operator in the process setup, which parameters should be set in according to the parameter set."));
        type.setExpert(false);
        types.add(type);
        return types;
    }

    @Override
    public int checkProperties() {
        int errorNumber = 0;
        try {
            final List<String[]> nameList = this.getParameterList(PARAMETER_NAME_MAP);
            if (nameList.size() > 0) {
                HashSet<String> operatorNames = new HashSet<String>();
                operatorNames.addAll(this.getProcess().getAllOperatorNames());
                for (final String[] pair : nameList) {
                    if (operatorNames.contains(pair[1])) continue;
                    ++errorNumber;
                    this.addError(new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), Collections.singletonList(new DictionaryQuickFix("replacement map", operatorNames, pair[1]){

                        @Override
                        public void insertChosenOption(String chosenOption) {
                            pair[1] = chosenOption;
                            ParameterSetter.this.setListParameter(ParameterSetter.PARAMETER_NAME_MAP, nameList);
                        }
                    }), "parameter_unknown_operator", PARAMETER_NAME_MAP, pair[1]));
                }
            } else {
                ++errorNumber;
                this.addError(new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), Collections.singletonList(new ParameterSettingQuickFix(this, PARAMETER_NAME_MAP, "")), "parameter_list_undefined", "the mapping of operator names"));
            }
        }
        catch (UndefinedParameterError e) {
            ++errorNumber;
            this.addError(new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), Collections.singletonList(new ParameterSettingQuickFix(this, PARAMETER_NAME_MAP, "")), "parameter_list_undefined", "the mapping of operator names"));
        }
        return errorNumber + super.checkProperties();
    }
}

