/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.meta.ParameterIteratingOperatorChain;
import com.rapidminer.operator.meta.ParameterSet;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import java.util.Collection;

public abstract class ParameterOptimizationOperator
extends ParameterIteratingOperatorChain {
    private final OutputPort performanceOutput = (OutputPort)this.getOutputPorts().createPort("performance");
    private final OutputPort parameterOutput = (OutputPort)this.getOutputPorts().createPort("parameter");

    public ParameterOptimizationOperator(OperatorDescription description) {
        super(description, "Optimization Process");
        this.getTransformer().addPassThroughRule(this.getPerformanceInnerSink(), this.performanceOutput);
        this.getTransformer().addRule(new GenerateNewMDRule(this.parameterOutput, ParameterSet.class));
        this.addValue(new ValueDouble("performance", "currently best performance"){

            @Override
            public double getDoubleValue() {
                return ParameterOptimizationOperator.this.getCurrentBestPerformance();
            }
        });
    }

    @Override
    protected PortPairExtender makeInnerSinkExtender() {
        return new PortPairExtender("result", this.getSubprocess(0).getInnerSinks(), this.getOutputPorts());
    }

    public abstract double getCurrentBestPerformance();

    protected void deliver(ParameterSet parameterSet) {
        this.parameterOutput.deliver(parameterSet);
        this.performanceOutput.deliver(parameterSet.getPerformance());
    }

    @Override
    protected boolean isPerformanceRequired() {
        return true;
    }

    @Deprecated
    protected PerformanceVector getPerformance(IOContainer input, Collection<Operator> operators) {
        throw new UnsupportedOperationException("getPerformance(IOContainer,Collection<Operator>) is deprecated. Please call getPerformance().");
    }
}

