/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.meta.ParameterIteratingOperatorChain;
import com.rapidminer.operator.meta.ParameterSet;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.CollectingPortPairExtender;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.value.ParameterValueRange;
import com.rapidminer.parameter.value.ParameterValues;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class ParameterIteration
extends ParameterIteratingOperatorChain {
    public static final String PARAMETER_PARAMETERS = "parameters";
    public static final String PARAMETER_SYNCHRONIZE = "synchronize";
    private PerformanceVector performance;
    private int iteration = 0;

    public ParameterIteration(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("performance", "The last performance."){

            @Override
            public double getDoubleValue() {
                if (ParameterIteration.this.performance != null) {
                    return ParameterIteration.this.performance.getMainCriterion().getAverage();
                }
                return Double.NaN;
            }
        });
        this.addValue(new ValueDouble("iteration", "The current iteration."){

            @Override
            public double getDoubleValue() {
                return ParameterIteration.this.iteration;
            }
        });
    }

    @Override
    protected boolean isPerformanceRequired() {
        return false;
    }

    @Override
    public int getParameterValueMode() {
        return 0;
    }

    @Override
    public void doWork() throws OperatorException {
        ((CollectingPortPairExtender)this.getInnerSinkExtender()).reset();
        boolean isSynchronized = this.getParameterAsBoolean(PARAMETER_SYNCHRONIZE);
        List<String[]> parameterList = this.getParameterList(PARAMETER_PARAMETERS);
        List<ParameterValues> parameterValuesList = this.parseParameterValues(parameterList);
        int numberOfCombinations = 1;
        int lastNumberOfValues = -1;
        Iterator<ParameterValues> iterator = parameterValuesList.iterator();
        while (iterator.hasNext()) {
            ParameterValues parameterValues = iterator.next();
            if (parameterValues instanceof ParameterValueRange) {
                this.getLogger().warning("Found (and deleted) parameter values range (" + parameterValues.getKey() + ") which makes no sense in grid parameter optimization");
                iterator.remove();
            }
            numberOfCombinations *= parameterValues.getNumberOfValues();
        }
        Operator[] operators = new Operator[parameterList.size()];
        String[] parameters = new String[parameterList.size()];
        String[][] values = new String[parameterList.size()][];
        int[] currentIndex = new int[parameterList.size()];
        int index = 0;
        for (ParameterValues parameterValues : parameterValuesList) {
            operators[index] = parameterValues.getOperator();
            parameters[index] = parameterValues.getParameterType().getKey();
            values[index] = parameterValues.getValuesArray();
            if (!isSynchronized) {
                numberOfCombinations *= values[index].length;
            } else {
                numberOfCombinations = values[index].length;
                if (lastNumberOfValues < 0) {
                    lastNumberOfValues = values[index].length;
                } else if (lastNumberOfValues != values[index].length) {
                    throw new UserError((Operator)this, 926);
                }
            }
            ++index;
        }
        this.iteration = 0;
        while (true) {
            boolean ok;
            block15: {
                int k;
                this.checkForStop();
                String[] currentValues = new String[parameters.length];
                for (int j = 0; j < operators.length; ++j) {
                    currentValues[j] = values[j][currentIndex[j]].trim();
                }
                ParameterSet set = new ParameterSet(operators, parameters, currentValues, null);
                this.evaluateParameterSet(set);
                ++this.iteration;
                ok = true;
                if (!isSynchronized) {
                    k = 0;
                    do {
                        int n = k;
                        currentIndex[n] = currentIndex[n] + 1;
                        if (currentIndex[n] < values[k].length) break block15;
                        currentIndex[k] = 0;
                    } while (++k < currentIndex.length);
                    ok = false;
                } else {
                    k = 0;
                    while (k < currentIndex.length) {
                        int n = k++;
                        currentIndex[n] = currentIndex[n] + 1;
                    }
                    if (currentIndex[0] >= values[0].length) {
                        ok = false;
                        break;
                    }
                }
            }
            if (!ok) break;
            this.inApplyLoop();
        }
    }

    protected void evaluateParameterSet(ParameterSet set) throws OperatorException {
        if (this.getLogger().isLoggable(Level.FINE)) {
            this.getLogger().fine("Evaluating parameter set: " + set.toString());
        }
        set.applyAll(this.getProcess(), null);
        this.performance = super.getPerformance();
        ((CollectingPortPairExtender)this.getInnerSinkExtender()).collect();
        if (this.performance == null) {
            this.getLogger().info("Inner operators of " + this.getName() + " do not provide performance vectors. Performance cannot be plotted.");
        }
    }

    @Override
    protected PortPairExtender makeInnerSinkExtender() {
        return new CollectingPortPairExtender("result", this.getSubprocess(0).getInnerSinks(), this.getOutputPorts());
    }

    @Override
    public boolean shouldAddNonConsumedInput() {
        return false;
    }

    @Override
    public boolean shouldAutoConnect(OutputPort outputPort) {
        if (outputPort.getName().startsWith("result")) {
            return this.getParameterAsBoolean("keep_output");
        }
        return super.shouldAutoConnect(outputPort);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_SYNCHRONIZE, "Synchronize parameter iteration", false));
        return types;
    }
}

