/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.RapidMiner;
import com.rapidminer.gui.properties.ConfigureParameterOptimizationDialogCreator;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.operator.ports.quickfix.ParameterSettingQuickFix;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeConfiguration;
import com.rapidminer.parameter.ParameterTypeInnerOperator;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeParameterValue;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeTupel;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.value.ParameterValueGrid;
import com.rapidminer.parameter.value.ParameterValueList;
import com.rapidminer.parameter.value.ParameterValueRange;
import com.rapidminer.parameter.value.ParameterValues;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class ParameterIteratingOperatorChain
extends OperatorChain {
    public static final String PARAMETER_PARAMETERS = "parameters";
    public static final String PARAMETER_VALUES = "values";
    public static final int VALUE_MODE_DISCRETE = 0;
    public static final int VALUE_MODE_CONTINUOUS = 1;
    private static final int PARAMETER_VALUES_ARRAY_LENGTH_RANGE = 2;
    private static final int PARAMETER_VALUES_ARRAY_LENGTH_GRID = 3;
    private static final int PARAMETER_VALUES_ARRAY_LENGTH_SCALED_GRID = 4;
    private static final String PARAMETER_OPERATOR_PARAMETER_PAIR = "operator_parameter_pair";
    private static final String PARAMETER_OPERATOR = "operator_name";
    private static final String PARAMETER_PARAMETER = "parameter_name";
    private final PortPairExtender inputExtender = new PortPairExtender("input", this.getInputPorts(), this.getSubprocess(0).getInnerSources());
    private final InputPort performanceInnerSink = (InputPort)this.getSubprocess(0).getInnerSinks().createPort("performance");
    private final PortPairExtender innerSinkExtender = this.makeInnerSinkExtender();

    public ParameterIteratingOperatorChain(OperatorDescription description) {
        this(description, "Subprocess");
    }

    public ParameterIteratingOperatorChain(OperatorDescription description, String subprocessName) {
        super(description, subprocessName);
        this.inputExtender.start();
        this.innerSinkExtender.start();
        this.getPerformanceInnerSink().addPrecondition(new SimplePrecondition(this.getPerformanceInnerSink(), new MetaData(PerformanceVector.class), this.isPerformanceRequired()));
        this.getTransformer().addRule(this.inputExtender.makePassThroughRule());
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addRule(this.innerSinkExtender.makePassThroughRule());
    }

    protected abstract PortPairExtender makeInnerSinkExtender();

    protected PortPairExtender getInnerSinkExtender() {
        return this.innerSinkExtender;
    }

    protected InputPort getPerformanceInnerSink() {
        return this.performanceInnerSink;
    }

    protected abstract boolean isPerformanceRequired();

    public abstract int getParameterValueMode();

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<ParameterValues> parseParameterValues(List<String[]> parameterList) throws OperatorException {
        if (this.getProcess() == null) {
            this.getLogger().warning("Cannot parse parameters while operator is not attached to a process.");
            return Collections.emptyList();
        }
        LinkedList<ParameterValues> parameterValuesList = new LinkedList<ParameterValues>();
        for (String[] pair : parameterList) {
            void var9_9;
            String[] operatorParameter = ParameterTypeTupel.transformString2Tupel(pair[0]);
            if (operatorParameter.length != 2) {
                throw new UserError((Operator)this, 907, pair[0]);
            }
            Operator operator = this.lookupOperator(operatorParameter[0]);
            if (operator == null) {
                throw new UserError((Operator)this, 109, operatorParameter[0]);
            }
            ParameterType parameterType = operator.getParameters().getParameterType(operatorParameter[1]);
            if (parameterType == null) {
                throw new UserError((Operator)this, 906, operatorParameter[0] + "." + operatorParameter[1]);
            }
            String parameterValuesString = pair[1];
            Object var9_10 = null;
            try {
                String[] parameterValuesArray;
                int startIndex = parameterValuesString.indexOf("[");
                if (startIndex >= 0) {
                    int endIndex = parameterValuesString.indexOf("]");
                    if (endIndex <= startIndex) throw new Exception("']' was missing");
                    parameterValuesArray = parameterValuesString.substring(startIndex + 1, endIndex).trim().split("[;:,]");
                    switch (parameterValuesArray.length) {
                        case 2: {
                            ParameterValueRange parameterValueRange = new ParameterValueRange(operator, parameterType, parameterValuesArray[0], parameterValuesArray[1]);
                            break;
                        }
                        case 3: {
                            ParameterValueGrid parameterValueGrid = new ParameterValueGrid(operator, parameterType, parameterValuesArray[0], parameterValuesArray[1], parameterValuesArray[2]);
                            break;
                        }
                        case 4: {
                            ParameterValueGrid parameterValueGrid = new ParameterValueGrid(operator, parameterType, parameterValuesArray[0], parameterValuesArray[1], parameterValuesArray[2], parameterValuesArray[3]);
                            break;
                        }
                        default: {
                            throw new Exception("parameter values string could not be parsed (too many arguments)");
                        }
                    }
                } else {
                    int colonIndex = parameterValuesString.indexOf(":");
                    if (colonIndex >= 0) {
                        parameterValuesArray = parameterValuesString.trim().split(":");
                        if (parameterValuesArray.length != 2) {
                            throw new Exception("wrong parameter range format");
                        }
                        ParameterValueRange parameterValueRange = new ParameterValueRange(operator, parameterType, parameterValuesArray[0], parameterValuesArray[1]);
                    } else if (parameterValuesString.length() != 0) {
                        String[] values = parameterValuesString.split(",");
                        ParameterValueList parameterValueList = new ParameterValueList(operator, parameterType, values);
                    }
                }
            }
            catch (Throwable e) {
                throw new UserError((Operator)this, 116, pair[0], "Unknown parameter value specification format: '" + pair[1] + "'. Error: " + e.getMessage());
            }
            if (var9_9 == null) continue;
            parameterValuesList.add((ParameterValues)var9_9);
        }
        return parameterValuesList;
    }

    protected void executeSubprocess() throws OperatorException {
        this.getSubprocess(0).execute();
    }

    protected PerformanceVector getPerformance() {
        return this.getPerformance(true);
    }

    protected PerformanceVector getPerformance(boolean cloneInput) {
        try {
            this.inputExtender.passDataThrough();
            this.executeSubprocess();
            if (this.isPerformanceRequired()) {
                return (PerformanceVector)this.getPerformanceInnerSink().getData();
            }
            return (PerformanceVector)this.getPerformanceInnerSink().getDataOrNull();
        }
        catch (OperatorException e) {
            this.getLogger().severe("Cannot evaluate performance for current parameter combination: " + e.getMessage());
            if (Boolean.parseBoolean(RapidMiner.getRapidMinerPropertyValue("rapidminer.general.debugmode"))) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected Collection<IOObject> getInnerResults() throws UserError {
        return this.innerSinkExtender.getData();
    }

    protected void passResultsThrough() {
        this.innerSinkExtender.passDataThrough();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterType type = new ParameterTypeConfiguration(ConfigureParameterOptimizationDialogCreator.class, this);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeList(PARAMETER_PARAMETERS, "The parameters.", (ParameterType)new ParameterTypeTupel(PARAMETER_OPERATOR_PARAMETER_PAIR, "The operator and it's parameter", new ParameterTypeInnerOperator(PARAMETER_OPERATOR, "The operator."), new ParameterTypeString(PARAMETER_PARAMETER, "The parameter.")), (ParameterType)new ParameterTypeParameterValue(PARAMETER_VALUES, "The value specifications for the parameters."));
        type.setHidden(true);
        types.add(type);
        return types;
    }

    @Override
    public int checkProperties() {
        boolean parametersPresent = false;
        try {
            List<ParameterValues> list = this.parseParameterValues(this.getParameterList(PARAMETER_PARAMETERS));
            if (list != null && list.size() > 0) {
                parametersPresent = true;
            }
        }
        catch (UndefinedParameterError e) {
        }
        catch (OperatorException operatorException) {
            // empty catch block
        }
        if (!parametersPresent) {
            this.addError(new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), Collections.singletonList(new ParameterSettingQuickFix(this, "configure_operator")), "parameter_combination_undefined", new Object[0]));
        }
        return super.checkProperties();
    }
}

