/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.DummyPortPairExtender;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.ports.quickfix.ParameterSettingQuickFix;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class ParameterCloner
extends Operator {
    public static final String PARAMETER_NAME_MAP = "name_map";
    private PortPairExtender dummyPorts = new DummyPortPairExtender("through", this.getInputPorts(), this.getOutputPorts());

    public ParameterCloner(OperatorDescription description) {
        super(description);
        this.dummyPorts.start();
        this.getTransformer().addRule(this.dummyPorts.makePassThroughRule());
    }

    @Override
    public void doWork() throws OperatorException {
        List<String[]> nameList = this.getParameterList(PARAMETER_NAME_MAP);
        for (String[] keyValue : nameList) {
            String[] source = keyValue[0].split("\\.");
            String[] target = keyValue[1].split("\\.");
            if (source.length != 2) {
                throw new UserError((Operator)this, 907, keyValue[0]);
            }
            if (target.length != 2) {
                throw new UserError((Operator)this, 907, keyValue[1]);
            }
            Operator operator = this.lookupOperator(source[0]);
            if (operator == null) {
                throw new UserError((Operator)this, 109, source[0]);
            }
            String value = operator.getParameter(source[1]);
            if (value == null) {
                throw new UserError((Operator)this, 213, source[1], source[0], this.getName());
            }
            operator = this.lookupOperator(target[0]);
            if (operator == null) {
                throw new UserError((Operator)this, 109, target[0]);
            }
            operator.getParameters().setParameter(target[1], value);
        }
        this.dummyPorts.passDataThrough();
    }

    @Override
    public int checkProperties() {
        int errorNumber = 0;
        try {
            List<String[]> nameList = this.getParameterList(PARAMETER_NAME_MAP);
            if (nameList.size() > 0) {
                HashSet<String> operatorNames = new HashSet<String>();
                operatorNames.addAll(this.getProcess().getAllOperatorNames());
                for (String[] pair : nameList) {
                    for (String operatorParameter : pair) {
                        String[] parts = operatorParameter.split("\\.");
                        if (parts.length != 2) {
                            ++errorNumber;
                            this.addError(new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), Collections.singletonList(new ParameterSettingQuickFix(this, PARAMETER_NAME_MAP, this.getParameterAsString(PARAMETER_NAME_MAP))), "parameter_wrong_format", PARAMETER_NAME_MAP));
                        }
                        if (!operatorNames.contains(parts[0])) {
                            ++errorNumber;
                            this.addError(new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), Collections.singletonList(new ParameterSettingQuickFix(this, PARAMETER_NAME_MAP, this.getParameterAsString(PARAMETER_NAME_MAP))), "parameter_unknown_operator", PARAMETER_NAME_MAP, parts[0]));
                            continue;
                        }
                        Operator operator = this.lookupOperator(parts[0]);
                        ParameterType type = operator.getParameterType(parts[1]);
                        if (type != null) continue;
                        ++errorNumber;
                        this.addError(new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), Collections.singletonList(new ParameterSettingQuickFix(this, PARAMETER_NAME_MAP, this.getParameterAsString(PARAMETER_NAME_MAP))), "parameter_unknown_parameter_for_operator", parts[1], parts[0]));
                    }
                }
            } else {
                ++errorNumber;
                this.addError(new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, this.getPortOwner(), Collections.singletonList(new ParameterSettingQuickFix(this, PARAMETER_NAME_MAP, "")), "parameter_list_undefined", "the mapping of operator names"));
            }
        }
        catch (UndefinedParameterError e) {
            ++errorNumber;
            this.addError(new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, this.getPortOwner(), Collections.singletonList(new ParameterSettingQuickFix(this, PARAMETER_NAME_MAP, "")), "parameter_list_undefined", "the mapping of operator names"));
        }
        return errorNumber + super.checkProperties();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeList(PARAMETER_NAME_MAP, "A list mapping operator parameters from the set to other operator parameters in the process setup.", (ParameterType)new ParameterTypeString("source", "The source parameter, specified as 'operator'.'parameter'. This value is copied to the target parameter."), (ParameterType)new ParameterTypeString("target", "The target parameter, specified as 'operator'.'parameter'."), false));
        return types;
    }
}

