/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPorts;
import com.rapidminer.operator.ports.MultiInputPortPairExtender;
import com.rapidminer.operator.ports.MultiOutputPortPairExtender;
import com.rapidminer.operator.ports.OutputPorts;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.List;

public class OperatorSelector
extends OperatorChain {
    public static final String PARAMETER_SELECT_WHICH = "select_which";
    private final MultiOutputPortPairExtender inputExtender = new MultiOutputPortPairExtender("input", this.getInputPorts(), new OutputPorts[]{this.getSubprocess(0).getInnerSources(), this.getSubprocess(1).getInnerSources()});
    private final MultiInputPortPairExtender outputExtender = new MultiInputPortPairExtender("output", this.getOutputPorts(), new InputPorts[]{this.getSubprocess(0).getInnerSinks(), this.getSubprocess(1).getInnerSinks()});

    public OperatorSelector(OperatorDescription description) {
        super(description, "Selection 1", "Selection 2");
        this.inputExtender.start();
        this.outputExtender.start();
        this.getTransformer().addRule(this.inputExtender.makePassThroughRule());
        this.getTransformer().addRule(new MDTransformationRule(){

            @Override
            public void transformMD() {
                int operatorIndex = -1;
                try {
                    operatorIndex = OperatorSelector.this.getParameterAsInt(OperatorSelector.PARAMETER_SELECT_WHICH) - 1;
                }
                catch (Exception e) {
                    // empty catch block
                }
                for (int i = 0; i < OperatorSelector.this.getNumberOfSubprocesses(); ++i) {
                    if (i == operatorIndex) continue;
                    OperatorSelector.this.getSubprocess(i).transformMetaData();
                }
                if (operatorIndex >= 0 && operatorIndex < OperatorSelector.this.getNumberOfSubprocesses()) {
                    OperatorSelector.this.getSubprocess(operatorIndex).transformMetaData();
                }
            }
        });
        this.getTransformer().addRule(this.outputExtender.makePassThroughRule());
    }

    @Override
    public boolean areSubprocessesExtendable() {
        return true;
    }

    @Override
    protected ExecutionUnit createSubprocess(int index) {
        return new ExecutionUnit(this, "Selection");
    }

    @Override
    public ExecutionUnit addSubprocess(int index) {
        ExecutionUnit newProcess = super.addSubprocess(index);
        this.inputExtender.addMultiPorts(newProcess.getInnerSources(), index);
        this.outputExtender.addMultiPorts(newProcess.getInnerSinks(), index);
        this.normalizeSubprocessNames();
        return newProcess;
    }

    @Override
    public ExecutionUnit removeSubprocess(int index) {
        ExecutionUnit oldProcess = super.removeSubprocess(index);
        this.inputExtender.removeMultiPorts(index);
        this.outputExtender.removeMultiPorts(index);
        this.normalizeSubprocessNames();
        return oldProcess;
    }

    private void normalizeSubprocessNames() {
        for (int i = 0; i < this.getNumberOfSubprocesses(); ++i) {
            this.getSubprocess(i).setName("Selection " + (i + 1));
        }
    }

    @Override
    public void doWork() throws OperatorException {
        int operatorIndex = this.getParameterAsInt(PARAMETER_SELECT_WHICH);
        if (operatorIndex < 1 || operatorIndex > this.getNumberOfSubprocesses()) {
            throw new UserError((Operator)this, 207, operatorIndex, PARAMETER_SELECT_WHICH, "must be between 1 and the number of inner operators.");
        }
        this.inputExtender.passDataThrough();
        this.getSubprocess(operatorIndex - 1).execute();
        this.outputExtender.passDataThrough(operatorIndex - 1);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_SELECT_WHICH, "Indicates which inner operator should be currently employed by this operator on the input objects.", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

