/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.CollectingPortPairExtender;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.Iterator;
import java.util.LinkedList;

public class MultipleLabelIterator
extends OperatorChain {
    private final InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set");
    private final OutputPort exampleInnerSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("example set");
    CollectingPortPairExtender outExtender = new CollectingPortPairExtender("out", this.getSubprocess(0).getInnerSinks(), this.getOutputPorts());

    public MultipleLabelIterator(OperatorDescription description) {
        super(description, "Iteration");
        this.outExtender.start();
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.exampleInnerSource, SetRelation.EQUAL){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) throws UndefinedParameterError {
                AttributeMetaData myLabel = metaData.getLabelMetaData();
                if (myLabel != null) {
                    metaData.removeAttribute(myLabel);
                }
                for (AttributeMetaData amd : metaData.getAllAttributes()) {
                    if (!amd.getName().startsWith("label")) continue;
                    amd.setRole("label");
                    break;
                }
                return metaData;
            }
        });
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addRule(this.outExtender.makePassThroughRule());
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        Attribute[] labels = this.getLabels(exampleSet);
        if (labels.length == 0) {
            throw new UserError((Operator)this, 105);
        }
        this.outExtender.reset();
        for (int i = 0; i < labels.length; ++i) {
            ExampleSet cloneSet = (ExampleSet)exampleSet.clone();
            cloneSet.getAttributes().setLabel(labels[i]);
            this.exampleInnerSource.deliver(cloneSet);
            this.getSubprocess(0).execute();
            this.outExtender.collect();
            this.inApplyLoop();
        }
    }

    private Attribute[] getLabels(ExampleSet exampleSet) {
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        Iterator<AttributeRole> i = exampleSet.getAttributes().specialAttributes();
        while (i.hasNext()) {
            AttributeRole role = i.next();
            String name = role.getSpecialName();
            if (!name.startsWith("label")) continue;
            attributes.add(role.getAttribute());
        }
        Attribute[] result = new Attribute[attributes.size()];
        attributes.toArray(result);
        return result;
    }
}

