/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.meta.AbstractIteratingOperatorChain;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import java.util.List;

public class IteratingOperatorChain
extends AbstractIteratingOperatorChain {
    public static final String PARAMETER_ITERATIONS = "iterations";
    public static final String PARAMETER_LIMIT_TIME = "limit_time";
    public static final String PARAMETER_TIMEOUT = "timeout";

    public IteratingOperatorChain(OperatorDescription description) {
        super(description);
    }

    @Override
    public void doWork() throws OperatorException {
        super.doWork();
    }

    @Override
    boolean shouldStop(IOContainer unused) throws OperatorException {
        int timeOut = this.getParameterAsInt(PARAMETER_TIMEOUT);
        long stoptime = Long.MAX_VALUE;
        if (this.getParameterAsBoolean(PARAMETER_LIMIT_TIME) && (stoptime = System.currentTimeMillis() + 60000L * (long)timeOut) >= 0L && System.currentTimeMillis() > stoptime) {
            this.getLogger().info("Timeout reached");
            return true;
        }
        return this.getIteration() >= this.getParameterAsInt(PARAMETER_ITERATIONS);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeInt(PARAMETER_ITERATIONS, "Number of iterations", 0, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_LIMIT_TIME, "If checked, the loop will be aborted at last after a specified time.", false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_TIMEOUT, "Timeout in minutes", 1, Integer.MAX_VALUE, 1);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_LIMIT_TIME, true, true));
        type.setExpert(true);
        types.add(type);
        return types;
    }
}

