/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.meta.ParameterOptimizationOperator;
import com.rapidminer.operator.meta.ParameterSet;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.value.ParameterValueRange;
import com.rapidminer.parameter.value.ParameterValues;
import java.util.Iterator;
import java.util.List;

public class GridSearchParameterOptimizationOperator
extends ParameterOptimizationOperator {
    protected Operator[] operators;
    protected String[] parameters;
    protected String[][] values;
    protected int[] currentIndex;
    protected int numberOfCombinations;
    protected int numberOfParameters;
    private ParameterSet best;

    public GridSearchParameterOptimizationOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public int getParameterValueMode() {
        return 0;
    }

    protected PerformanceVector computeCurrentPerformeance() {
        for (int j = 0; j < this.operators.length; ++j) {
            this.operators[j].getParameters().setParameter(this.parameters[j], this.values[j][this.currentIndex[j]]);
            this.getLogger().fine(this.operators[j] + "." + this.parameters[j] + " = " + this.values[j][this.currentIndex[j]]);
        }
        return super.getPerformance();
    }

    protected void getParametersToOptimize() throws OperatorException {
        List<ParameterValues> parameterValuesList = this.parseParameterValues(this.getParameterList("parameters"));
        this.numberOfCombinations = 1;
        this.numberOfParameters = parameterValuesList.size();
        Iterator<ParameterValues> iterator = parameterValuesList.iterator();
        while (iterator.hasNext()) {
            ParameterValues parameterValues = iterator.next();
            if (parameterValues instanceof ParameterValueRange) {
                this.logWarning("found (and deleted) parameter values range (" + parameterValues.getKey() + ") which makes no sense in grid parameter optimization");
                iterator.remove();
            }
            this.numberOfCombinations *= parameterValues.getNumberOfValues();
        }
        this.operators = new Operator[parameterValuesList.size()];
        this.parameters = new String[parameterValuesList.size()];
        this.values = new String[parameterValuesList.size()][];
        this.currentIndex = new int[parameterValuesList.size()];
        int i = 0;
        for (ParameterValues parameterValues : parameterValuesList) {
            this.operators[i] = parameterValues.getOperator();
            this.parameters[i] = parameterValues.getParameterType().getKey();
            this.values[i] = parameterValues.getValuesArray();
            ++i;
        }
    }

    @Override
    public double getCurrentBestPerformance() {
        if (this.best != null) {
            return this.best.getPerformance().getMainCriterion().getAverage();
        }
        return Double.NaN;
    }

    @Override
    public void doWork() throws OperatorException {
        this.getParametersToOptimize();
        this.log("Total number of combinations is " + this.numberOfCombinations);
        if (this.numberOfCombinations <= 1) {
            throw new UserError((Operator)this, 922);
        }
        int counter = 1;
        this.best = null;
        while (true) {
            boolean ok;
            block5: {
                this.getLogger().fine("Using parameter set " + counter + " / " + this.numberOfCombinations + ":");
                PerformanceVector performance = this.computeCurrentPerformeance();
                if (this.best == null || performance != null && performance.compareTo(this.best.getPerformance()) > 0) {
                    String[] bestValues = new String[this.parameters.length];
                    for (int j = 0; j < this.parameters.length; ++j) {
                        bestValues[j] = this.values[j][this.currentIndex[j]];
                    }
                    this.best = new ParameterSet(this.operators, this.parameters, bestValues, performance);
                    this.passResultsThrough();
                }
                int k = 0;
                ok = true;
                do {
                    int n = k;
                    this.currentIndex[n] = this.currentIndex[n] + 1;
                    if (this.currentIndex[n] < this.values[k].length) break block5;
                    this.currentIndex[k] = 0;
                } while (++k < this.currentIndex.length);
                ok = false;
            }
            if (!ok) break;
            this.inApplyLoop();
            ++counter;
        }
        this.deliver(this.best);
    }
}

