/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.ValueString;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.math.CombinationGenerator;
import java.util.List;

public class FeatureSubsetIteration
extends OperatorChain {
    private final InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private final OutputPort exampleSetInnerSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("example set");
    public static final String PARAMETER_LIMIT_MAX = "limit_max_number";
    public static final String PARAMETER_MAX_NUMBER_OF_ATTRIBUTES = "max_number_of_attributes";
    public static final String PARAMETER_MIN_NUMBER_OF_ATTRIBUTES = "min_number_of_attributes";
    public static final String PARAMETER_USE_EXACT_NUMBER = "use_exact_number";
    public static final String PARAMETER_EXACT_NUMBER_OF_ATTRIBUTES = "exact_number_of_attributes";
    private int iteration = -1;
    private int featureNumber = -1;
    private String featureNames = null;

    public FeatureSubsetIteration(OperatorDescription description) {
        super(description, "Subprocess");
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.exampleSetInnerSource, SetRelation.SUBSET));
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.exampleSetOutput, SetRelation.SUBSET));
        this.addValue(new ValueDouble("iteration", "The current iteration."){

            @Override
            public double getDoubleValue() {
                return FeatureSubsetIteration.this.iteration;
            }
        });
        this.addValue(new ValueDouble("feature_number", "The number of used features in the current iteration."){

            @Override
            public double getDoubleValue() {
                return FeatureSubsetIteration.this.featureNumber;
            }
        });
        this.addValue(new ValueString("feature_names", "The names of the used features in the current iteration."){

            @Override
            public String getStringValue() {
                return FeatureSubsetIteration.this.featureNames;
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        int exactNumberOfFeatures;
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        Attribute[] allAttributes = exampleSet.getAttributes().createRegularAttributeArray();
        int minNumberOfFeatures = this.getParameterAsInt(PARAMETER_MIN_NUMBER_OF_ATTRIBUTES);
        int maxNumberOfFeatures = this.getParameterAsBoolean(PARAMETER_LIMIT_MAX) ? this.getParameterAsInt(PARAMETER_MAX_NUMBER_OF_ATTRIBUTES) : -1;
        int n = exactNumberOfFeatures = this.getParameterAsBoolean(PARAMETER_USE_EXACT_NUMBER) ? this.getParameterAsInt(PARAMETER_EXACT_NUMBER_OF_ATTRIBUTES) : -1;
        if (exactNumberOfFeatures > 0) {
            this.log("Using exact number of features for feature subset iteration (" + exactNumberOfFeatures + "), ignoring possibly defined range for the number of features.");
        } else {
            if (maxNumberOfFeatures > 0 && minNumberOfFeatures > maxNumberOfFeatures) {
                throw new UserError((Operator)this, 210, PARAMETER_MAX_NUMBER_OF_ATTRIBUTES, PARAMETER_MIN_NUMBER_OF_ATTRIBUTES);
            }
            if (maxNumberOfFeatures > allAttributes.length) {
                throw new UserError((Operator)this, 207, maxNumberOfFeatures + "", PARAMETER_MAX_NUMBER_OF_ATTRIBUTES, " the parameter value must be smaller than the number of attributes of the input example set.");
            }
            if (maxNumberOfFeatures == -1) {
                maxNumberOfFeatures = exampleSet.getAttributes().size();
            }
        }
        this.iteration = 0;
        this.featureNumber = 0;
        this.featureNames = "?";
        if (exactNumberOfFeatures > 0) {
            if (exactNumberOfFeatures > allAttributes.length) {
                throw new UserError((Operator)this, 207, exactNumberOfFeatures + "", PARAMETER_EXACT_NUMBER_OF_ATTRIBUTES, " the parameter value must be larger than the number of attributes of the input example set.");
            }
            this.applyOnAllWithExactNumber(exampleSet, allAttributes, exactNumberOfFeatures);
        } else {
            this.applyOnAllInRange(exampleSet, allAttributes, minNumberOfFeatures, maxNumberOfFeatures);
        }
        this.exampleSetOutput.deliver(exampleSet);
    }

    private void applyInnerOperators(ExampleSet exampleSet) throws OperatorException {
        this.exampleSetInnerSource.deliver(exampleSet);
        this.getSubprocess(0).execute();
    }

    private void applyOnAllWithExactNumber(ExampleSet exampleSet, Attribute[] allAttributes, int exactNumberOfFeatures) throws OperatorException {
        ExampleSet workingSet = (ExampleSet)exampleSet.clone();
        this.featureNumber = exactNumberOfFeatures;
        if (exactNumberOfFeatures == 1) {
            for (int i = 0; i < allAttributes.length; ++i) {
                workingSet.getAttributes().clearRegular();
                workingSet.getAttributes().addRegular(allAttributes[i]);
                ++this.iteration;
                this.featureNames = allAttributes[i].getName();
                this.applyInnerOperators(workingSet);
            }
        } else if (exactNumberOfFeatures == allAttributes.length) {
            StringBuffer nameBuffer = new StringBuffer();
            boolean first = true;
            workingSet.getAttributes().clearRegular();
            for (int i = 0; i < allAttributes.length; ++i) {
                Attribute attribute = allAttributes[i];
                workingSet.getAttributes().addRegular(attribute);
                if (!first) {
                    nameBuffer.append(", ");
                }
                nameBuffer.append(attribute.getName());
                first = false;
            }
            ++this.iteration;
            this.featureNames = nameBuffer.toString();
            this.applyInnerOperators(workingSet);
        } else {
            CombinationGenerator combinationGenerator = new CombinationGenerator(allAttributes.length, exactNumberOfFeatures);
            while (combinationGenerator.hasMore()) {
                int[] indices = combinationGenerator.getNext();
                StringBuffer nameBuffer = new StringBuffer();
                boolean first = true;
                workingSet.getAttributes().clearRegular();
                for (int i = 0; i < indices.length; ++i) {
                    Attribute attribute = allAttributes[indices[i]];
                    workingSet.getAttributes().addRegular(attribute);
                    if (!first) {
                        nameBuffer.append(", ");
                    }
                    nameBuffer.append(attribute.getName());
                    first = false;
                }
                ++this.iteration;
                this.featureNames = nameBuffer.toString();
                this.applyInnerOperators(workingSet);
            }
        }
    }

    private void applyOnAllInRange(ExampleSet exampleSet, Attribute[] allAttributes, int minNumberOfFeatures, int maxNumberOfFeatures) throws OperatorException {
        for (int i = minNumberOfFeatures; i <= maxNumberOfFeatures; ++i) {
            this.applyOnAllWithExactNumber(exampleSet, allAttributes, i);
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeBoolean(PARAMETER_USE_EXACT_NUMBER, "If checked, it will be iterated over all combination with a specified number of attributes.", false, false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_EXACT_NUMBER_OF_ATTRIBUTES, "Determines the exact number of attributes used for the combinations.", -1, Integer.MAX_VALUE, -1);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_EXACT_NUMBER, true, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MIN_NUMBER_OF_ATTRIBUTES, "Determines the minimum number of attributes used for the combinations.", 1, Integer.MAX_VALUE, 1);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_EXACT_NUMBER, true, false));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_LIMIT_MAX, "If checked, it will be iterated over all combination with at most a specified number of attributes.", false, false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MAX_NUMBER_OF_ATTRIBUTES, "Determines the maximum number of attributes used for the combinations.", -1, Integer.MAX_VALUE, -1);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_LIMIT_MAX, true, true));
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

