/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.ValueString;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.List;

public class FeatureIterator
extends OperatorChain {
    private final InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private final OutputPort exampleSetInnerSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("example set");
    private final InputPort exampleSetInnerSink = (InputPort)this.getSubprocess(0).getInnerSinks().createPort("example set");
    public static final String PARAMETER_ITERATION_MACRO = "iteration_macro";
    public static final String DEFAULT_ITERATION_MACRO_NAME = "loop_attribute";
    private int iteration;
    private String currentName = null;
    private final AttributeSubsetSelector attributeSelector = new AttributeSubsetSelector(this, this.exampleSetInput);

    public FeatureIterator(OperatorDescription description) {
        super(description, "Subprocess");
        this.exampleSetInnerSink.addPrecondition(new SimplePrecondition(this.exampleSetInnerSink, new ExampleSetMetaData(), false));
        this.getTransformer().addRule(new PassThroughRule(this.exampleSetInput, this.exampleSetInnerSource, false));
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addRule(new PassThroughRule(this.exampleSetInput, this.exampleSetOutput, false){

            @Override
            public MetaData modifyMetaData(MetaData unmodifiedMetaData) {
                if (FeatureIterator.this.exampleSetInnerSink.isConnected()) {
                    return FeatureIterator.this.exampleSetInnerSink.getMetaData();
                }
                return new ExampleSetMetaData();
            }
        });
        this.addValue(new ValueDouble("iteration", "The number of the current iteration / loop."){

            @Override
            public double getDoubleValue() {
                return FeatureIterator.this.iteration;
            }
        });
        this.addValue(new ValueString("feature_name", "The number of the current feature."){

            @Override
            public String getStringValue() {
                return FeatureIterator.this.currentName;
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        String iterationMacroName = this.getParameterAsString(PARAMETER_ITERATION_MACRO);
        this.iteration = 0;
        for (Attribute attribute : this.attributeSelector.getAttributeSubset(exampleSet, false)) {
            String name = attribute.getName();
            this.getProcess().getMacroHandler().addMacro(iterationMacroName, name);
            this.currentName = name;
            this.applyInnerOperators(exampleSet);
            this.checkForStop();
            ++this.iteration;
        }
        this.getProcess().getMacroHandler().removeMacro(iterationMacroName);
        if (this.exampleSetInnerSink.isConnected()) {
            this.exampleSetOutput.deliver((IOObject)this.exampleSetInnerSink.getData());
        } else {
            this.exampleSetOutput.deliver(exampleSet);
        }
    }

    private void applyInnerOperators(ExampleSet inputExampleSet) throws OperatorException {
        ExampleSet iterationSet = this.exampleSetInnerSink.isConnected() ? (this.iteration == 0 ? inputExampleSet : (ExampleSet)this.exampleSetInnerSink.getData()) : (ExampleSet)inputExampleSet.clone();
        this.exampleSetInnerSource.deliver(iterationSet);
        this.getSubprocess(0).execute();
    }

    @Override
    public boolean shouldAutoConnect(InputPort inputPort) {
        if (inputPort == this.exampleSetInnerSink) {
            return true;
        }
        return super.shouldAutoConnect(inputPort);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(this.attributeSelector.getParameterTypes());
        types.add(new ParameterTypeString(PARAMETER_ITERATION_MACRO, "The name of the macro which holds the name of the current feature in each iteration.", DEFAULT_ITERATION_MACRO_NAME, false));
        return types;
    }
}

