/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.SimpleOperatorChain;
import com.rapidminer.operator.Value;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.LinkedList;
import java.util.List;

public class ExceptionHandling
extends SimpleOperatorChain {
    public static final String PARAMETER_EXCEPTION_MACRO = "exception_macro";
    private boolean withoutError = true;
    private Exception exception;

    public ExceptionHandling(OperatorDescription description) {
        super(description);
        this.addValue(new Value("success", "Indicates whether the executionwas successful"){

            @Override
            public Object getValue() {
                return ExceptionHandling.this.withoutError;
            }

            @Override
            public boolean isNominal() {
                return true;
            }
        });
        this.addValue(new Value("exception", "The exception that occured during execution."){

            @Override
            public Object getValue() {
                return ExceptionHandling.this.exception;
            }

            @Override
            public boolean isNominal() {
                return true;
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        this.withoutError = true;
        this.exception = null;
        try {
            super.doWork();
        }
        catch (Exception e) {
            this.logWarning("Error occurred and will be neglected by " + this.getName() + ": " + e.getMessage());
            if (this.isParameterSet(PARAMETER_EXCEPTION_MACRO)) {
                this.getProcess().getMacroHandler().addMacro(this.getParameterAsString(PARAMETER_EXCEPTION_MACRO), e.getMessage());
            }
            this.withoutError = false;
            this.exception = e;
            for (OutputPort port : this.getOutputPorts().getAllPorts()) {
                port.deliver(null);
            }
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.add(new ParameterTypeString(PARAMETER_EXCEPTION_MACRO, "The name of the macro a potentially occuring exception message will be stored in.", true));
        types.addAll(super.getParameterTypes());
        return types;
    }
}

